<?php
/**
 * Project:                 sh404SEF - SEO extension for Joomla!
 *
 * @author                  Yannick Gaultier
 * @copyright               (c) Yannick Gaultier - Weeblr llc - 2021
 * @package                 sh404SEF
 * @license                 http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @version                 4.23.2.4269
 *
 * 2021-06-09
 */

namespace Weeblr\Wblib\V_SH4_4269\Platform;

//
/* Security check to ensure this file is being included by a parent file.*/
defined('_JEXEC') || defined('WBLIB_V_SH4_4269_ROOT_PATH') || die;

/**
 *
 * Holds data for a database instance description
 *
 * @author weeblr
 *
 */
interface Platformdbconnectioninterface
{
	public function getQuery();

	public function getPrefix();

	public function quote($data, $escape = true);

	public function quoteName($data);

	public function quoteTable($data);

	public function escape($data, $extra = false);

	public function getNullDate();

	public function setQuery($query, $offset = 0, $limit = 0);

	public function loadAssoc();

	public function loadAssocList($key = null, $column = null);

	public function loadColumn($offset = 0);

	public function loadObject();

	public function loadObjectList($key = '');

	public function loadResult();

	public function loadRow();

	public function loadRowList($key = null);

	public function getInsertId();

	public function transactionStart();

	public function transactionCommit();

	public function transactionRollback();

	public function execute();

}
