<?php
/**
 * Project:                 sh404SEF - SEO extension for Joomla!
 *
 * @author           Yannick Gaultier
 * @copyright        (c) Yannick Gaultier - Weeblr llc - 2021
 * @package          sh404SEF
 * @license          http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @version          4.23.2.4269
 * @date         2021-06-09
 */

namespace Weeblr\Wblib\V_SH4_4269\Seo;

// Security check to ensure this file is being included by a parent file.
use Weeblr\Wblib\V_SH4_4269\Base\Base;
use Weeblr\Wblib\V_SH4_4269\System;
use Weeblr\Wblib\V_SH4_4269\Wb;

defined('_JEXEC') || defined('WBLIB_V_SH4_4269_ROOT_PATH') || die;

/**
 * HTML output helper.
 *
 */
class Helper extends Base
{
	/**
	 * @var string|null The detected search engines making the request, if any.
	 */
	private static $engine;

	/**
	 * @var bool Whether to validate search engines requesting IP address against domains.
	 */
	private static $validateIp = true;

	/**
	 * @var string This configuration unique ID.
	 */
	protected $engines = [
		'bing',
		'google'
	];

	/**
	 * Stores options.
	 *
	 * @param array $options Can inject custom factory and platform.
	 */
	public function __construct($options = [])
	{
		parent::__construct($options);

		self::$validateIp = Wb\arrayGet(
			$options,
			'validateIp',
			true
		);
	}

	/**
	 * List of supported search engines identifiers.
	 *
	 * @return string[]
	 */
	public function getSupported()
	{
		return $this->engines;
	}

	/**
	 * Returns the search engines code making the current request or empty string
	 * if no search engines is recognized.
	 *
	 * @return string
	 */
	public function getRequestingSearchEngine()
	{
		if (is_null(self::$engine))
		{
			$this->detect(self::$validateIp);
		}

		return self::$engine;
	}

	/**
	 * Whether current request is by a known search engine.
	 *
	 * @return bool
	 */
	public function isSearchEngineRequest()
	{
		if (is_null(self::$engine))
		{
			$this->detect(self::$validateIp);
		}

		return self::$engine != Searchengine::NONE;
	}

	/**
	 * Iterate over known search engines to recognize the request.
	 *
	 * @param bool $validateIp Whether to validate the IP address against search engines hosts.
	 *
	 */
	private function detect($validateIp = true)
	{
		$userAgent = System\Http::userAgent();
		$ip        = System\Http::getIpAddress();

		foreach ($this->engines as $engineId)
		{
			$engine = $this->factory->getA(
				'Weeblr\Wblib\V_SH4_4269\Seo\\' . ucfirst($engineId),
				[
					'validateIp' => self::$validateIp
				]
			);
			if ($engine->isRequesting(
				$userAgent,
				$ip,
				$validateIp
			))
			{
				self::$engine = $engineId;
				break;
			}
		}
	}
}
