/**ABDB**/CREATE TABLE `i52lw_viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `i52lw_viewlevels`  VALUES 
('1', 'Public', '0', '[1]'),
('2', 'Registered', '2', '[6,2,8]'),
('3', 'Special', '3', '[6,3,8]'),
('5', 'Guest', '1', '[9]'),
('6', 'Super Users', '4', '[8]');
/**ABDB**/CREATE TABLE `i52lw_utf8_conversion` (
  `converted` tinyint(4) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `i52lw_utf8_conversion`  VALUES 
('5');
/**ABDB**/CREATE TABLE `i52lw_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(400) NOT NULL DEFAULT '',
  `username` varchar(150) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `password` varchar(100) NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT 0,
  `sendEmail` tinyint(4) DEFAULT 0,
  `registerDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastvisitDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `activation` varchar(100) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  `lastResetTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Date of last password reset',
  `resetCount` int(11) NOT NULL DEFAULT 0 COMMENT 'Count of password resets since lastResetTime',
  `otpKey` varchar(1000) NOT NULL DEFAULT '' COMMENT 'Two factor authentication encrypted keys',
  `otep` varchar(1000) NOT NULL DEFAULT '' COMMENT 'One time emergency passwords',
  `requireReset` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Require user to reset password on next login',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_name` (`name`(100)),
  KEY `idx_block` (`block`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=303 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `i52lw_users`  VALUES 
('301', 'Super User', 'Avanti_Admin', 'anthony@avanti-ict.com', '$2y$10$7aEu8lB9zVcjYXbdGmpCiexGVQVEr9za6G/Fw/u6pSZ0VybnsQnli', '0', '1', '2019-02-04 22:57:07', '2020-07-07 00:11:13', '0', '', '0000-00-00 00:00:00', '0', '', '', '0'),
('302', 'Laura Wills', 'LW_Admin', 'laura@mssngr.com', '$2y$10$4XTDAyzwQLtFwhR7jQ9Mf.I7Yt.1TjowY1YCOaAUoMa7UeAM7kKuG', '0', '0', '2019-02-22 04:29:12', '2019-03-02 23:08:20', '', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"helpsite\":\"\",\"timezone\":\"\"}', '0000-00-00 00:00:00', '0', '', '', '0');
/**ABDB**/CREATE TABLE `i52lw_usergroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Adjacency List Reference Id',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `title` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_parent_title_lookup` (`parent_id`,`title`),
  KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `i52lw_usergroups`  VALUES 
('1', '0', '1', '18', 'Public'),
('2', '1', '8', '15', 'Registered'),
('3', '2', '9', '14', 'Author'),
('4', '3', '10', '13', 'Editor'),
('5', '4', '11', '12', 'Publisher'),
('6', '1', '4', '7', 'Manager'),
('7', '6', '5', '6', 'Administrator'),
('8', '1', '16', '17', 'Super Users'),
('9', '1', '2', '3', 'Guest');
/**ABDB**/CREATE TABLE `i52lw_user_usergroup_map` (
  `user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Foreign Key to #__users.id',
  `group_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Foreign Key to #__usergroups.id',
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `i52lw_user_usergroup_map`  VALUES 
('301', '8'),
('302', '2'),
('302', '7');
/**ABDB**/CREATE TABLE `i52lw_user_profiles` (
  `user_id` int(11) NOT NULL,
  `profile_key` varchar(100) NOT NULL,
  `profile_value` text NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  UNIQUE KEY `idx_user_id_profile_key` (`user_id`,`profile_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Simple user profile storage table';
/**ABDB**/CREATE TABLE `i52lw_user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `subject` varchar(100) NOT NULL DEFAULT '',
  `body` text NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `review_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `i52lw_user_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(150) NOT NULL,
  `token` varchar(255) NOT NULL,
  `series` varchar(191) NOT NULL,
  `invalid` tinyint(4) NOT NULL,
  `time` varchar(200) NOT NULL,
  `uastring` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series` (`series`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `i52lw_updates` (
  `update_id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT 0,
  `extension_id` int(11) DEFAULT 0,
  `name` varchar(100) DEFAULT '',
  `description` text NOT NULL,
  `element` varchar(100) DEFAULT '',
  `type` varchar(20) DEFAULT '',
  `folder` varchar(20) DEFAULT '',
  `client_id` tinyint(3) DEFAULT 0,
  `version` varchar(32) DEFAULT '',
  `data` text NOT NULL,
  `detailsurl` text NOT NULL,
  `infourl` text NOT NULL,
  `extra_query` varchar(1000) DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=405 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Available Updates';
/**ABDB**/INSERT INTO `i52lw_updates`  VALUES 
('321', '2', '0', 'Armenian', '', 'pkg_hy-AM', 'package', '', '0', '3.4.4.1', '', 'https://update.joomla.org/language/details3/hy-AM_details.xml', '', ''),
('322', '2', '0', 'Malay', '', 'pkg_ms-MY', 'package', '', '0', '3.4.1.2', '', 'https://update.joomla.org/language/details3/ms-MY_details.xml', '', ''),
('323', '2', '0', 'Romanian', '', 'pkg_ro-RO', 'package', '', '0', '3.9.13.1', '', 'https://update.joomla.org/language/details3/ro-RO_details.xml', '', ''),
('324', '2', '0', 'Flemish', '', 'pkg_nl-BE', 'package', '', '0', '3.9.19.2', '', 'https://update.joomla.org/language/details3/nl-BE_details.xml', '', ''),
('325', '2', '0', 'Chinese Traditional', '', 'pkg_zh-TW', 'package', '', '0', '3.8.0.1', '', 'https://update.joomla.org/language/details3/zh-TW_details.xml', '', ''),
('326', '2', '0', 'French', '', 'pkg_fr-FR', 'package', '', '0', '3.9.19.2', '', 'https://update.joomla.org/language/details3/fr-FR_details.xml', '', ''),
('327', '2', '0', 'Galician', '', 'pkg_gl-ES', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/gl-ES_details.xml', '', ''),
('328', '2', '0', 'Georgian', '', 'pkg_ka-GE', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/ka-GE_details.xml', '', ''),
('329', '2', '0', 'Greek', '', 'pkg_el-GR', 'package', '', '0', '3.9.18.1', '', 'https://update.joomla.org/language/details3/el-GR_details.xml', '', ''),
('330', '2', '0', 'Japanese', '', 'pkg_ja-JP', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/ja-JP_details.xml', '', ''),
('331', '2', '0', 'Hebrew', '', 'pkg_he-IL', 'package', '', '0', '3.1.1.2', '', 'https://update.joomla.org/language/details3/he-IL_details.xml', '', ''),
('332', '2', '0', 'Bengali', '', 'pkg_bn-BD', 'package', '', '0', '3.8.10.1', '', 'https://update.joomla.org/language/details3/bn-BD_details.xml', '', ''),
('333', '2', '0', 'Hungarian', '', 'pkg_hu-HU', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/hu-HU_details.xml', '', ''),
('334', '2', '0', 'Afrikaans', '', 'pkg_af-ZA', 'package', '', '0', '3.9.16.1', '', 'https://update.joomla.org/language/details3/af-ZA_details.xml', '', ''),
('335', '2', '0', 'Arabic Unitag', '', 'pkg_ar-AA', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/ar-AA_details.xml', '', ''),
('336', '2', '0', 'Belarusian', '', 'pkg_be-BY', 'package', '', '0', '3.2.1.2', '', 'https://update.joomla.org/language/details3/be-BY_details.xml', '', ''),
('337', '2', '0', 'Bulgarian', '', 'pkg_bg-BG', 'package', '', '0', '3.6.5.2', '', 'https://update.joomla.org/language/details3/bg-BG_details.xml', '', ''),
('338', '2', '0', 'Catalan', '', 'pkg_ca-ES', 'package', '', '0', '3.9.11.2', '', 'https://update.joomla.org/language/details3/ca-ES_details.xml', '', ''),
('339', '2', '0', 'Chinese Simplified', '', 'pkg_zh-CN', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/zh-CN_details.xml', '', ''),
('340', '2', '0', 'Croatian', '', 'pkg_hr-HR', 'package', '', '0', '3.9.19.2', '', 'https://update.joomla.org/language/details3/hr-HR_details.xml', '', ''),
('341', '2', '0', 'Czech', '', 'pkg_cs-CZ', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/cs-CZ_details.xml', '', ''),
('342', '2', '0', 'Danish', '', 'pkg_da-DK', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/da-DK_details.xml', '', ''),
('343', '2', '0', 'Dutch', '', 'pkg_nl-NL', 'package', '', '0', '3.9.19.2', '', 'https://update.joomla.org/language/details3/nl-NL_details.xml', '', ''),
('344', '2', '0', 'Esperanto', '', 'pkg_eo-XX', 'package', '', '0', '3.8.11.1', '', 'https://update.joomla.org/language/details3/eo-XX_details.xml', '', ''),
('345', '2', '0', 'Estonian', '', 'pkg_et-EE', 'package', '', '0', '3.9.14.2', '', 'https://update.joomla.org/language/details3/et-EE_details.xml', '', ''),
('346', '2', '0', 'Italian', '', 'pkg_it-IT', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/it-IT_details.xml', '', ''),
('347', '2', '0', 'Khmer', '', 'pkg_km-KH', 'package', '', '0', '3.4.5.1', '', 'https://update.joomla.org/language/details3/km-KH_details.xml', '', ''),
('348', '2', '0', 'Korean', '', 'pkg_ko-KR', 'package', '', '0', '3.8.9.1', '', 'https://update.joomla.org/language/details3/ko-KR_details.xml', '', ''),
('349', '2', '0', 'Latvian', '', 'pkg_lv-LV', 'package', '', '0', '3.7.3.1', '', 'https://update.joomla.org/language/details3/lv-LV_details.xml', '', ''),
('350', '2', '0', 'Lithuanian', '', 'pkg_lt-LT', 'package', '', '0', '3.9.6.1', '', 'https://update.joomla.org/language/details3/lt-LT_details.xml', '', '');
/**ABDB**/INSERT INTO `i52lw_updates`  VALUES 
('351', '2', '0', 'Macedonian', '', 'pkg_mk-MK', 'package', '', '0', '3.6.5.1', '', 'https://update.joomla.org/language/details3/mk-MK_details.xml', '', ''),
('352', '2', '0', 'Norwegian Bokmal', '', 'pkg_nb-NO', 'package', '', '0', '3.8.11.1', '', 'https://update.joomla.org/language/details3/nb-NO_details.xml', '', ''),
('353', '2', '0', 'Norwegian Nynorsk', '', 'pkg_nn-NO', 'package', '', '0', '3.4.2.1', '', 'https://update.joomla.org/language/details3/nn-NO_details.xml', '', ''),
('354', '2', '0', 'Persian', '', 'pkg_fa-IR', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/fa-IR_details.xml', '', ''),
('355', '2', '0', 'Polish', '', 'pkg_pl-PL', 'package', '', '0', '3.9.13.1', '', 'https://update.joomla.org/language/details3/pl-PL_details.xml', '', ''),
('356', '2', '0', 'Portuguese', '', 'pkg_pt-PT', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/pt-PT_details.xml', '', ''),
('357', '2', '0', 'Russian', '', 'pkg_ru-RU', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/ru-RU_details.xml', '', ''),
('358', '2', '0', 'English AU', '', 'pkg_en-AU', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/en-AU_details.xml', '', ''),
('359', '2', '0', 'Slovak', '', 'pkg_sk-SK', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/sk-SK_details.xml', '', ''),
('360', '2', '0', 'English US', '', 'pkg_en-US', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/en-US_details.xml', '', ''),
('361', '2', '0', 'Swedish', '', 'pkg_sv-SE', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/sv-SE_details.xml', '', ''),
('362', '2', '0', 'Syriac', '', 'pkg_sy-IQ', 'package', '', '0', '3.4.5.1', '', 'https://update.joomla.org/language/details3/sy-IQ_details.xml', '', ''),
('363', '2', '0', 'Tamil', '', 'pkg_ta-IN', 'package', '', '0', '3.9.19.2', '', 'https://update.joomla.org/language/details3/ta-IN_details.xml', '', ''),
('364', '2', '0', 'Thai', '', 'pkg_th-TH', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/th-TH_details.xml', '', ''),
('365', '2', '0', 'Turkish', '', 'pkg_tr-TR', 'package', '', '0', '3.9.4.1', '', 'https://update.joomla.org/language/details3/tr-TR_details.xml', '', ''),
('366', '2', '0', 'Ukrainian', '', 'pkg_uk-UA', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/uk-UA_details.xml', '', ''),
('367', '2', '0', 'Uyghur', '', 'pkg_ug-CN', 'package', '', '0', '3.7.5.2', '', 'https://update.joomla.org/language/details3/ug-CN_details.xml', '', ''),
('368', '2', '0', 'Albanian', '', 'pkg_sq-AL', 'package', '', '0', '3.1.1.2', '', 'https://update.joomla.org/language/details3/sq-AL_details.xml', '', ''),
('369', '2', '0', 'Basque', '', 'pkg_eu-ES', 'package', '', '0', '3.7.5.1', '', 'https://update.joomla.org/language/details3/eu-ES_details.xml', '', ''),
('370', '2', '0', 'Hindi', '', 'pkg_hi-IN', 'package', '', '0', '3.3.6.2', '', 'https://update.joomla.org/language/details3/hi-IN_details.xml', '', ''),
('371', '2', '0', 'German DE', '', 'pkg_de-DE', 'package', '', '0', '3.9.19.2', '', 'https://update.joomla.org/language/details3/de-DE_details.xml', '', ''),
('372', '2', '0', 'Portuguese Brazil', '', 'pkg_pt-BR', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/pt-BR_details.xml', '', ''),
('373', '2', '0', 'Serbian Latin', '', 'pkg_sr-YU', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/sr-YU_details.xml', '', ''),
('374', '2', '0', 'Spanish', '', 'pkg_es-ES', 'package', '', '0', '3.9.18.1', '', 'https://update.joomla.org/language/details3/es-ES_details.xml', '', ''),
('375', '2', '0', 'Bosnian', '', 'pkg_bs-BA', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/bs-BA_details.xml', '', ''),
('376', '2', '0', 'Serbian Cyrillic', '', 'pkg_sr-RS', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/sr-RS_details.xml', '', ''),
('377', '2', '0', 'Vietnamese', '', 'pkg_vi-VN', 'package', '', '0', '3.2.1.2', '', 'https://update.joomla.org/language/details3/vi-VN_details.xml', '', ''),
('378', '2', '0', 'Bahasa Indonesia', '', 'pkg_id-ID', 'package', '', '0', '3.6.2.1', '', 'https://update.joomla.org/language/details3/id-ID_details.xml', '', ''),
('379', '2', '0', 'Finnish', '', 'pkg_fi-FI', 'package', '', '0', '3.9.16.1', '', 'https://update.joomla.org/language/details3/fi-FI_details.xml', '', ''),
('380', '2', '0', 'Swahili', '', 'pkg_sw-KE', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/sw-KE_details.xml', '', '');
/**ABDB**/INSERT INTO `i52lw_updates`  VALUES 
('381', '2', '0', 'Montenegrin', '', 'pkg_srp-ME', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/srp-ME_details.xml', '', ''),
('382', '2', '0', 'English CA', '', 'pkg_en-CA', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/en-CA_details.xml', '', ''),
('383', '2', '0', 'French CA', '', 'pkg_fr-CA', 'package', '', '0', '3.6.5.1', '', 'https://update.joomla.org/language/details3/fr-CA_details.xml', '', ''),
('384', '2', '0', 'Welsh', '', 'pkg_cy-GB', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/cy-GB_details.xml', '', ''),
('385', '2', '0', 'Sinhala', '', 'pkg_si-LK', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/si-LK_details.xml', '', ''),
('386', '2', '0', 'Dari Persian', '', 'pkg_prs-AF', 'package', '', '0', '3.4.4.3', '', 'https://update.joomla.org/language/details3/prs-AF_details.xml', '', ''),
('387', '2', '0', 'Turkmen', '', 'pkg_tk-TM', 'package', '', '0', '3.5.0.2', '', 'https://update.joomla.org/language/details3/tk-TM_details.xml', '', ''),
('388', '2', '0', 'Irish', '', 'pkg_ga-IE', 'package', '', '0', '3.8.13.1', '', 'https://update.joomla.org/language/details3/ga-IE_details.xml', '', ''),
('389', '2', '0', 'Dzongkha', '', 'pkg_dz-BT', 'package', '', '0', '3.6.2.1', '', 'https://update.joomla.org/language/details3/dz-BT_details.xml', '', ''),
('390', '2', '0', 'Slovenian', '', 'pkg_sl-SI', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/sl-SI_details.xml', '', ''),
('391', '2', '0', 'Spanish CO', '', 'pkg_es-CO', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/es-CO_details.xml', '', ''),
('392', '2', '0', 'German CH', '', 'pkg_de-CH', 'package', '', '0', '3.9.19.2', '', 'https://update.joomla.org/language/details3/de-CH_details.xml', '', ''),
('393', '2', '0', 'German AT', '', 'pkg_de-AT', 'package', '', '0', '3.9.19.2', '', 'https://update.joomla.org/language/details3/de-AT_details.xml', '', ''),
('394', '2', '0', 'German LI', '', 'pkg_de-LI', 'package', '', '0', '3.9.19.2', '', 'https://update.joomla.org/language/details3/de-LI_details.xml', '', ''),
('395', '2', '0', 'German LU', '', 'pkg_de-LU', 'package', '', '0', '3.9.19.2', '', 'https://update.joomla.org/language/details3/de-LU_details.xml', '', ''),
('396', '2', '0', 'English NZ', '', 'pkg_en-NZ', 'package', '', '0', '3.9.19.1', '', 'https://update.joomla.org/language/details3/en-NZ_details.xml', '', ''),
('397', '2', '0', 'Kazakh', '', 'pkg_kk-KZ', 'package', '', '0', '3.9.17.1', '', 'https://update.joomla.org/language/details3/kk-KZ_details.xml', '', ''),
('400', '7', '0', 'FOF 3.x Stable', '', 'lib_fof30', 'library', '', '1', '3.6.1', '', 'http://cdn.akeebabackup.com/updates/fof3_file.xml', 'https://www.akeebabackup.com/download/fof3/3-6-1.html', '');
/**ABDB**/CREATE TABLE `i52lw_update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT 0,
  `extension_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';
/**ABDB**/INSERT INTO `i52lw_update_sites_extensions`  VALUES 
('1', '700'),
('2', '802'),
('3', '28'),
('4', '10000'),
('5', '10003'),
('6', '10005'),
('7', '10006'),
('8', '10013'),
('9', '10012'),
('10', '10017'),
('11', '10018');
/**ABDB**/CREATE TABLE `i52lw_update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT '',
  `type` varchar(20) DEFAULT '',
  `location` text NOT NULL,
  `enabled` int(11) DEFAULT 0,
  `last_check_timestamp` bigint(20) DEFAULT 0,
  `extra_query` varchar(1000) DEFAULT '',
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Update Sites';
/**ABDB**/INSERT INTO `i52lw_update_sites`  VALUES 
('1', 'Joomla! Core', 'collection', 'https://update.joomla.org/core/list.xml', '1', '1594080674', ''),
('2', 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_3.xml', '1', '1594080675', ''),
('3', 'Joomla! Update Component Update Site', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', '1', '1594081089', ''),
('4', 'WebInstaller Update Site', 'extension', 'https://appscdn.joomla.org/webapps/jedapps/webinstaller.xml', '1', '1594080675', ''),
('5', 'YOOtheme Installer', 'extension', 'http://yootheme.com/api/update/installer_yootheme_j33.xml', '1', '1594080676', ''),
('6', 'YOOtheme', 'extension', 'https://yootheme.com/api/update/yootheme_j33.xml', '1', '1594080676', ''),
('7', 'FOF 3.x', 'extension', 'http://cdn.akeebabackup.com/updates/fof3_file.xml', '1', '1594080676', ''),
('8', 'Akeeba FEF', 'extension', 'http://cdn.akeebabackup.com/updates/fef.xml', '1', '1594080676', ''),
('9', 'Akeeba Backup Core', 'extension', 'https://cdn.akeebabackup.com/updates/pkgakeebacore.xml', '1', '1594080676', ''),
('10', 'Admin Tools Core', 'extension', 'https://cdn.akeebabackup.com/updates/pkgadmintoolscore.xml', '1', '1594080676', ''),
('11', 'Phoca Open Graph Plugin', 'extension', 'https://raw.githubusercontent.com/PhocaCz/PhocaOpenGraphPlugin/master/manifest.xml', '1', '1594080676', '');
/**ABDB**/CREATE TABLE `i52lw_ucm_history` (
  `version_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ucm_item_id` int(10) unsigned NOT NULL,
  `ucm_type_id` int(10) unsigned NOT NULL,
  `version_note` varchar(255) NOT NULL DEFAULT '' COMMENT 'Optional version name',
  `save_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `character_count` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Number of characters in this version.',
  `sha1_hash` varchar(50) NOT NULL DEFAULT '' COMMENT 'SHA1 hash of the version_data column.',
  `version_data` mediumtext NOT NULL COMMENT 'json-encoded string of version data',
  `keep_forever` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0=auto delete; 1=keep',
  PRIMARY KEY (`version_id`),
  KEY `idx_ucm_item_id` (`ucm_type_id`,`ucm_item_id`),
  KEY `idx_save_date` (`save_date`)
) ENGINE=InnoDB AUTO_INCREMENT=791 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `i52lw_ucm_history`  VALUES 
('528', '6', '1', '', '2019-02-26 01:12:41', '302', '15862', '046823adb031b611ada510c2822b42716e173ab0', '{\"id\":\"6\",\"asset_id\":\"68\",\"title\":\"Contact\",\"alias\":\"contact\",\"introtext\":\"<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<img src=\\\"images\\/EB-Images\\/Contact\\/ElaineBroe_Contact-OverlappingThoughtBubbles-Graphic.png\\\" alt=\\\"\\\">\\n<h6>&nbsp;<br \\/>&nbsp;<\\/h6>\\n<h3>Contact me.<\\/h3>\\n<h3><p><span style=\\\"font-size: 42px; line-height: 1.2em;\\\">Contact me.<\\/span><\\/p><\\/h3>\\n<h2><p><span style=\\\"font-size: 36px; line-height: 1.2em;\\\">Contact me.<\\/span><\\/p><\\/h2>\\n<div><p>Let\\u2019s get those changes started.<\\/p><\\/div>\\n<div><p><span style=\\\"font-size: 24px;\\\">Let\\u2019s get those changes started.<\\/span><\\/p><\\/div>\\n<div><p><span style=\\\"font-size: 28px; line-height: 34px;\\\">Let\\u2019s get those changes started.<\\/span><\\/p><\\/div>\\n<h2>ELAINE BROE<\\/h2>\\n<ul>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Contact\\/Email-Icon.png\\\" alt=\\\"\\\">\\n\\n<a href=\\\"mailto:info@elainebroe.com\\\"><p class=\\\"uk-text-large\\\"><span style=\\\"color: #000000;\\\">info@elainebroe.com<\\/span><\\/p><\\/a>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Contact\\/LinkedIn-Icon.png\\\" alt=\\\"\\\">\\n\\n<a href=\\\"https:\\/\\/www.linkedin.com\\/in\\/elaine-broe-18540b13\\/\\\"><p class=\\\"uk-text-large\\\"><span style=\\\"color: #000000;\\\">LinkedIn<\\/span><\\/p><\\/a>\\n\\n    <\\/li>\\n    <\\/ul>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Spacer.png\\\" alt=\\\"\\\">\\n\",\"fulltext\":\"<!-- {\\\"name\\\":\\\"About - Page\\\",\\\"type\\\":\\\"layout\\\",\\\"children\\\":[{\\\"name\\\":\\\"TopBanner-Section\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"bottom-left\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"dark\\\",\\\"animation\\\":\\\"fade\\\",\\\"padding_remove_bottom\\\":true,\\\"padding_remove_top\\\":true,\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_width\\\":\\\"700\\\",\\\"image_height\\\":\\\"400\\\",\\\"overlap\\\":false,\\\"css\\\":\\\".el-section {\\\\n    background-color: #F8925E;\\\\n}\\\\n\\\\n@media only screen and (min-width: 1250px) {\\\\n.el-section {\\\\n    min-height: 738px;\\\\n}\\\\n\\\\n.uk-grid {\\\\n    min-height: 738px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1249px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 550px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"s\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"expand\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"margin_remove_bottom\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_Contact-OverlappingThoughtBubbles-Graphic.png\\\",\\\"image_size\\\":\\\"contain\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"m\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_height\\\":\\\"\\\",\\\"image_parallax_breakpoint\\\":\\\"\\\",\\\"image_parallax_bgx_start\\\":\\\"\\\",\\\"image_parallax_bgy_start\\\":\\\"70\\\",\\\"image_width\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"Image uk-visible@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"-55\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-20\\\",\\\"parallax_x_end\\\":\\\"-20\\\",\\\"parallax_y_end\\\":\\\"-55\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Image uk-hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"15\\\",\\\"class\\\":\\\"uk-hidden@m\\\",\\\"margin_remove_bottom\\\":true,\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-5\\\",\\\"parallax_x_end\\\":\\\"-5\\\",\\\"parallax_y_end\\\":\\\"15\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Top Graphic hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"remove-vertical\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_Contact-OverlappingThoughtBubbles-Graphic.png\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden@m\\\",\\\"image_width\\\":\\\"250\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"light\\\",\\\"padding\\\":\\\"none\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  \\\\n  \\\\n  padding-left: 120px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\\n\\\\n\\\\n.uk-tile-default {\\\\n    background: rgba(255, 255, 255, 0.0);\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"spacer @desktop\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h6\\\",\\\"title_style\\\":\\\"heading-hero\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"&nbsp;<br \\\\\\/>&nbsp;\\\",\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden\\\",\\\"margin_remove_top\\\":true}},{\\\"name\\\":\\\"Headline @L\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Contact me.\\\",\\\"class\\\":\\\"uk-light uk-visible@l hidden@m\\\"}},{\\\"name\\\":\\\"Headline @M\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 42px; line-height: 1.2em;\\\\\\\">Contact me.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@m uk-hidden@l\\\"}},{\\\"name\\\":\\\"Headline @S\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h3\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"left\\\",\\\"text_align_breakpoint\\\":\\\"s\\\",\\\"text_align_fallback\\\":\\\"center\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 36px; line-height: 1.2em;\\\\\\\">Contact me.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-hidden@m uk-light\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true}},{\\\"name\\\":\\\"Text @S hidden@s\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"small\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>Let\\\\u2019s get those changes started.<\\\\\\/p>\\\",\\\"class\\\":\\\"uk-hidden@m uk-light uk-visible@s\\\",\\\"margin_remove_bottom\\\":false}},{\\\"name\\\":\\\"Text @M\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"small\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 24px;\\\\\\\">Let\\\\u2019s get those changes started.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@m uk-hidden@l\\\",\\\"margin_remove_bottom\\\":false}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 28px; line-height: 34px;\\\\\\\">Let\\\\u2019s get those changes started.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@l\\\"}}]}]}]},{\\\"name\\\":\\\"Intro Text-PictureBlock\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"padding_remove_top\\\":false,\\\"padding_remove_bottom\\\":false,\\\"css\\\":\\\".el-section {\\\\n    background-color: #F8925E;\\\\n    \\\\n}\\\\n\\\\n@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 90px;\\\\n  padding-right: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n  padding-right: 30px;\\\\n}\\\\n}\\\",\\\"image_effect\\\":\\\"\\\",\\\"animation_delay\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"collapse\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true,\\\"divider\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"muted\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 45px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"slide-left-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"ELAINE BROE\\\",\\\"css\\\":\\\"\\\"}},{\\\"type\\\":\\\"list\\\",\\\"props\\\":{\\\"show_image\\\":true,\\\"show_link\\\":true,\\\"image_align\\\":\\\"left\\\",\\\"image_vertical_align\\\":false,\\\"list_style\\\":\\\"\\\",\\\"content_style\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"icon_color\\\":\\\"\\\",\\\"link_style\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"},\\\"children\\\":[{\\\"type\\\":\\\"list_item\\\",\\\"props\\\":{\\\"icon_color\\\":\\\"\\\",\\\"content\\\":\\\"<p class=\\\\\\\"uk-text-large\\\\\\\"><span style=\\\\\\\"color: #000000;\\\\\\\">info@elainebroe.com<\\\\\\/span><\\\\\\/p>\\\",\\\"icon\\\":\\\"\\\",\\\"link\\\":\\\"mailto:info@elainebroe.com\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/Email-Icon.png\\\"}},{\\\"type\\\":\\\"list_item\\\",\\\"props\\\":{\\\"icon_color\\\":\\\"\\\",\\\"content\\\":\\\"<p class=\\\\\\\"uk-text-large\\\\\\\"><span style=\\\\\\\"color: #000000;\\\\\\\">LinkedIn<\\\\\\/span><\\\\\\/p>\\\",\\\"icon\\\":\\\"\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.linkedin.com\\\\\\/in\\\\\\/elaine-broe-18540b13\\\\\\/\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/LinkedIn-Icon.png\\\",\\\"link_target\\\":true}}]}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-left\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_CoachingElaineSmiles04.jpg\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Spacer.png\\\"}}]}]}]}],\\\"version\\\":\\\"1.18.10\\\",\\\"props\\\":[]} -->\",\"state\":\"1\",\"catid\":\"2\",\"created\":\"2019-02-05 00:13:20\",\"created_by\":\"301\",\"created_by_alias\":\"\",\"modified\":\"2019-02-26 01:12:41\",\"modified_by\":\"302\",\"checked_out\":\"0\",\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2019-02-05 00:13:20\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":15,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"209\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('571', '6', '1', '', '2019-02-26 17:26:32', '301', '15862', '895798d8cb8e7623fcdc55c323ff0bbf15ab5910', '{\"id\":\"6\",\"asset_id\":\"68\",\"title\":\"Contact\",\"alias\":\"contact\",\"introtext\":\"<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<img src=\\\"images\\/EB-Images\\/Contact\\/ElaineBroe_Contact-OverlappingThoughtBubbles-Graphic.png\\\" alt=\\\"\\\">\\n<h6>&nbsp;<br \\/>&nbsp;<\\/h6>\\n<h3>Contact me.<\\/h3>\\n<h3><p><span style=\\\"font-size: 42px; line-height: 1.2em;\\\">Contact me.<\\/span><\\/p><\\/h3>\\n<h2><p><span style=\\\"font-size: 36px; line-height: 1.2em;\\\">Contact me.<\\/span><\\/p><\\/h2>\\n<div><p>Let\\u2019s get those changes started.<\\/p><\\/div>\\n<div><p><span style=\\\"font-size: 24px;\\\">Let\\u2019s get those changes started.<\\/span><\\/p><\\/div>\\n<div><p><span style=\\\"font-size: 28px; line-height: 34px;\\\">Let\\u2019s get those changes started.<\\/span><\\/p><\\/div>\\n<h2>ELAINE BROE<\\/h2>\\n<ul>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Contact\\/Email-Icon.png\\\" alt=\\\"\\\">\\n\\n<a href=\\\"mailto:info@elainebroe.com\\\"><p class=\\\"uk-text-large\\\"><span style=\\\"color: #000000;\\\">info@elainebroe.com<\\/span><\\/p><\\/a>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Contact\\/LinkedIn-Icon.png\\\" alt=\\\"\\\">\\n\\n<a href=\\\"https:\\/\\/www.linkedin.com\\/in\\/elaine-broe-18540b13\\/\\\"><p class=\\\"uk-text-large\\\"><span style=\\\"color: #000000;\\\">LinkedIn<\\/span><\\/p><\\/a>\\n\\n    <\\/li>\\n    <\\/ul>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Spacer.png\\\" alt=\\\"\\\">\\n\",\"fulltext\":\"<!-- {\\\"name\\\":\\\"About - Page\\\",\\\"type\\\":\\\"layout\\\",\\\"children\\\":[{\\\"name\\\":\\\"TopBanner-Section\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"bottom-left\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"dark\\\",\\\"animation\\\":\\\"fade\\\",\\\"padding_remove_bottom\\\":true,\\\"padding_remove_top\\\":true,\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_width\\\":\\\"700\\\",\\\"image_height\\\":\\\"400\\\",\\\"overlap\\\":false,\\\"css\\\":\\\".el-section {\\\\n    background-color: #F8925E;\\\\n}\\\\n\\\\n@media only screen and (min-width: 1250px) {\\\\n.el-section {\\\\n    min-height: 638px;\\\\n}\\\\n\\\\n.uk-grid {\\\\n    min-height: 638px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1249px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 550px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"s\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"expand\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"margin_remove_bottom\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_Contact-OverlappingThoughtBubbles-Graphic.png\\\",\\\"image_size\\\":\\\"contain\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"m\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_height\\\":\\\"\\\",\\\"image_parallax_breakpoint\\\":\\\"\\\",\\\"image_parallax_bgx_start\\\":\\\"\\\",\\\"image_parallax_bgy_start\\\":\\\"70\\\",\\\"image_width\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"Image uk-visible@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"-55\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-20\\\",\\\"parallax_x_end\\\":\\\"-20\\\",\\\"parallax_y_end\\\":\\\"-55\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Image uk-hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"15\\\",\\\"class\\\":\\\"uk-hidden@m\\\",\\\"margin_remove_bottom\\\":true,\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-5\\\",\\\"parallax_x_end\\\":\\\"-5\\\",\\\"parallax_y_end\\\":\\\"15\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Top Graphic hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"remove-vertical\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_Contact-OverlappingThoughtBubbles-Graphic.png\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden@m\\\",\\\"image_width\\\":\\\"250\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"light\\\",\\\"padding\\\":\\\"none\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  \\\\n  \\\\n  padding-left: 120px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\\n\\\\n\\\\n.uk-tile-default {\\\\n    background: rgba(255, 255, 255, 0.0);\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"spacer @desktop\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h6\\\",\\\"title_style\\\":\\\"heading-hero\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"&nbsp;<br \\\\\\/>&nbsp;\\\",\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden\\\",\\\"margin_remove_top\\\":true}},{\\\"name\\\":\\\"Headline @L\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Contact me.\\\",\\\"class\\\":\\\"uk-light uk-visible@l hidden@m\\\"}},{\\\"name\\\":\\\"Headline @M\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 42px; line-height: 1.2em;\\\\\\\">Contact me.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@m uk-hidden@l\\\"}},{\\\"name\\\":\\\"Headline @S\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h3\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"left\\\",\\\"text_align_breakpoint\\\":\\\"s\\\",\\\"text_align_fallback\\\":\\\"center\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 36px; line-height: 1.2em;\\\\\\\">Contact me.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-hidden@m uk-light\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true}},{\\\"name\\\":\\\"Text @S hidden@s\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"small\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>Let\\\\u2019s get those changes started.<\\\\\\/p>\\\",\\\"class\\\":\\\"uk-hidden@m uk-light uk-visible@s\\\",\\\"margin_remove_bottom\\\":false}},{\\\"name\\\":\\\"Text @M\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"small\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 24px;\\\\\\\">Let\\\\u2019s get those changes started.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@m uk-hidden@l\\\",\\\"margin_remove_bottom\\\":false}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 28px; line-height: 34px;\\\\\\\">Let\\\\u2019s get those changes started.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@l\\\"}}]}]}]},{\\\"name\\\":\\\"Intro Text-PictureBlock\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"padding_remove_top\\\":false,\\\"padding_remove_bottom\\\":false,\\\"css\\\":\\\".el-section {\\\\n    background-color: #F8925E;\\\\n    \\\\n}\\\\n\\\\n@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 90px;\\\\n  padding-right: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n  padding-right: 30px;\\\\n}\\\\n}\\\",\\\"image_effect\\\":\\\"\\\",\\\"animation_delay\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"collapse\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true,\\\"divider\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"muted\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 45px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"slide-left-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"ELAINE BROE\\\",\\\"css\\\":\\\"\\\"}},{\\\"type\\\":\\\"list\\\",\\\"props\\\":{\\\"show_image\\\":true,\\\"show_link\\\":true,\\\"image_align\\\":\\\"left\\\",\\\"image_vertical_align\\\":false,\\\"list_style\\\":\\\"\\\",\\\"content_style\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"icon_color\\\":\\\"\\\",\\\"link_style\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"},\\\"children\\\":[{\\\"type\\\":\\\"list_item\\\",\\\"props\\\":{\\\"icon_color\\\":\\\"\\\",\\\"content\\\":\\\"<p class=\\\\\\\"uk-text-large\\\\\\\"><span style=\\\\\\\"color: #000000;\\\\\\\">info@elainebroe.com<\\\\\\/span><\\\\\\/p>\\\",\\\"icon\\\":\\\"\\\",\\\"link\\\":\\\"mailto:info@elainebroe.com\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/Email-Icon.png\\\"}},{\\\"type\\\":\\\"list_item\\\",\\\"props\\\":{\\\"icon_color\\\":\\\"\\\",\\\"content\\\":\\\"<p class=\\\\\\\"uk-text-large\\\\\\\"><span style=\\\\\\\"color: #000000;\\\\\\\">LinkedIn<\\\\\\/span><\\\\\\/p>\\\",\\\"icon\\\":\\\"\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.linkedin.com\\\\\\/in\\\\\\/elaine-broe-18540b13\\\\\\/\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/LinkedIn-Icon.png\\\",\\\"link_target\\\":true}}]}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-left\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_CoachingElaineSmiles04.jpg\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Spacer.png\\\"}}]}]}]}],\\\"version\\\":\\\"1.18.10\\\",\\\"props\\\":[]} -->\",\"state\":\"1\",\"catid\":\"2\",\"created\":\"2019-02-05 00:13:20\",\"created_by\":\"301\",\"created_by_alias\":\"\",\"modified\":\"2019-02-26 17:26:32\",\"modified_by\":\"301\",\"checked_out\":\"0\",\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2019-02-05 00:13:20\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":16,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"213\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('579', '6', '1', '', '2019-02-26 19:15:02', '301', '15964', '41f8d50b458a53e5984ad12d21c6ed41e5664648', '{\"id\":\"6\",\"asset_id\":\"68\",\"title\":\"Contact\",\"alias\":\"contact\",\"introtext\":\"<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<img src=\\\"images\\/EB-Images\\/Contact\\/ElaineBroe_Contact-OverlappingThoughtBubbles-Graphic.png\\\" alt=\\\"\\\">\\n<h6>&nbsp;<br \\/>&nbsp;<\\/h6>\\n<h3>Contact me.<\\/h3>\\n<h3><p><span style=\\\"font-size: 42px; line-height: 1.2em;\\\">Contact me.<\\/span><\\/p><\\/h3>\\n<h2><p><span style=\\\"font-size: 36px; line-height: 1.2em;\\\">Contact me.<\\/span><\\/p><\\/h2>\\n<div><p>Let\\u2019s get those changes started.<\\/p><\\/div>\\n<div><p><span style=\\\"font-size: 24px;\\\">Let\\u2019s get those changes started.<\\/span><\\/p><\\/div>\\n<div><p><span style=\\\"font-size: 28px; line-height: 34px;\\\">Let\\u2019s get those changes started.<\\/span><\\/p><\\/div>\\n<h2>ELAINE BROE<\\/h2>\\n<ul>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Contact\\/Email-Icon.png\\\" alt=\\\"\\\">\\n\\n<a href=\\\"mailto:info@elainebroe.com\\\"><p class=\\\"uk-text-large\\\"><span style=\\\"color: #000000;\\\">info@elainebroe.com<\\/span><\\/p><\\/a>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Contact\\/LinkedIn-Icon.png\\\" alt=\\\"\\\">\\n\\n<a href=\\\"https:\\/\\/www.linkedin.com\\/in\\/elaine-broe-18540b13\\/\\\"><p class=\\\"uk-text-large\\\"><span style=\\\"color: #000000;\\\">LinkedIn<\\/span><\\/p><\\/a>\\n\\n    <\\/li>\\n    <\\/ul>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Spacer.png\\\" alt=\\\"\\\">\\n\",\"fulltext\":\"<!-- {\\\"name\\\":\\\"About - Page\\\",\\\"type\\\":\\\"layout\\\",\\\"children\\\":[{\\\"name\\\":\\\"TopBanner-Section\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"bottom-left\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"dark\\\",\\\"animation\\\":\\\"fade\\\",\\\"padding_remove_bottom\\\":true,\\\"padding_remove_top\\\":true,\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_width\\\":\\\"700\\\",\\\"image_height\\\":\\\"400\\\",\\\"overlap\\\":false,\\\"css\\\":\\\".el-section {\\\\n    background-color: #F8925E;\\\\n}\\\\n\\\\n@media only screen and (min-width: 1250px) {\\\\n.el-section {\\\\n    min-height: 638px;\\\\n}\\\\n\\\\n.uk-grid {\\\\n    min-height: 638px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1249px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 550px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1000px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 350px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"s\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"expand\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"margin_remove_bottom\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_Contact-OverlappingThoughtBubbles-Graphic.png\\\",\\\"image_size\\\":\\\"contain\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"m\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_height\\\":\\\"\\\",\\\"image_parallax_breakpoint\\\":\\\"\\\",\\\"image_parallax_bgx_start\\\":\\\"\\\",\\\"image_parallax_bgy_start\\\":\\\"70\\\",\\\"image_width\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"Image uk-visible@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"-55\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-20\\\",\\\"parallax_x_end\\\":\\\"-20\\\",\\\"parallax_y_end\\\":\\\"-55\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Image uk-hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"15\\\",\\\"class\\\":\\\"uk-hidden@m\\\",\\\"margin_remove_bottom\\\":true,\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-5\\\",\\\"parallax_x_end\\\":\\\"-5\\\",\\\"parallax_y_end\\\":\\\"15\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Top Graphic hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"remove-vertical\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_Contact-OverlappingThoughtBubbles-Graphic.png\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden@m\\\",\\\"image_width\\\":\\\"250\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"light\\\",\\\"padding\\\":\\\"none\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  \\\\n  \\\\n  padding-left: 120px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 20px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\\n\\\\n\\\\n.uk-tile-default {\\\\n    background: rgba(255, 255, 255, 0.0);\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"spacer @desktop\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h6\\\",\\\"title_style\\\":\\\"heading-hero\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"&nbsp;<br \\\\\\/>&nbsp;\\\",\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden\\\",\\\"margin_remove_top\\\":true}},{\\\"name\\\":\\\"Headline @L\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Contact me.\\\",\\\"class\\\":\\\"uk-light uk-visible@l hidden@m\\\"}},{\\\"name\\\":\\\"Headline @M\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 42px; line-height: 1.2em;\\\\\\\">Contact me.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@m uk-hidden@l\\\"}},{\\\"name\\\":\\\"Headline @S\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h3\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"left\\\",\\\"text_align_breakpoint\\\":\\\"s\\\",\\\"text_align_fallback\\\":\\\"center\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 36px; line-height: 1.2em;\\\\\\\">Contact me.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-hidden@m uk-light\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true}},{\\\"name\\\":\\\"Text @S hidden@s\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"small\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>Let\\\\u2019s get those changes started.<\\\\\\/p>\\\",\\\"class\\\":\\\"uk-hidden@m uk-light uk-visible@s\\\",\\\"margin_remove_bottom\\\":false}},{\\\"name\\\":\\\"Text @M\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"small\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 24px;\\\\\\\">Let\\\\u2019s get those changes started.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@m uk-hidden@l\\\",\\\"margin_remove_bottom\\\":false}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 28px; line-height: 34px;\\\\\\\">Let\\\\u2019s get those changes started.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@l\\\"}}]}]}]},{\\\"name\\\":\\\"Intro Text-PictureBlock\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"padding_remove_top\\\":false,\\\"padding_remove_bottom\\\":false,\\\"css\\\":\\\".el-section {\\\\n    background-color: #F8925E;\\\\n    \\\\n}\\\\n\\\\n@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 90px;\\\\n  padding-right: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n  padding-right: 30px;\\\\n}\\\\n}\\\",\\\"image_effect\\\":\\\"\\\",\\\"animation_delay\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"collapse\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true,\\\"divider\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"muted\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 45px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"slide-left-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"ELAINE BROE\\\",\\\"css\\\":\\\"\\\"}},{\\\"type\\\":\\\"list\\\",\\\"props\\\":{\\\"show_image\\\":true,\\\"show_link\\\":true,\\\"image_align\\\":\\\"left\\\",\\\"image_vertical_align\\\":false,\\\"list_style\\\":\\\"\\\",\\\"content_style\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"icon_color\\\":\\\"\\\",\\\"link_style\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"},\\\"children\\\":[{\\\"type\\\":\\\"list_item\\\",\\\"props\\\":{\\\"icon_color\\\":\\\"\\\",\\\"content\\\":\\\"<p class=\\\\\\\"uk-text-large\\\\\\\"><span style=\\\\\\\"color: #000000;\\\\\\\">info@elainebroe.com<\\\\\\/span><\\\\\\/p>\\\",\\\"icon\\\":\\\"\\\",\\\"link\\\":\\\"mailto:info@elainebroe.com\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/Email-Icon.png\\\"}},{\\\"type\\\":\\\"list_item\\\",\\\"props\\\":{\\\"icon_color\\\":\\\"\\\",\\\"content\\\":\\\"<p class=\\\\\\\"uk-text-large\\\\\\\"><span style=\\\\\\\"color: #000000;\\\\\\\">LinkedIn<\\\\\\/span><\\\\\\/p>\\\",\\\"icon\\\":\\\"\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.linkedin.com\\\\\\/in\\\\\\/elaine-broe-18540b13\\\\\\/\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/LinkedIn-Icon.png\\\",\\\"link_target\\\":true}}]}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-left\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_CoachingElaineSmiles04.jpg\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Spacer.png\\\"}}]}]}]}],\\\"version\\\":\\\"1.18.10\\\",\\\"props\\\":[]} -->\",\"state\":\"1\",\"catid\":\"2\",\"created\":\"2019-02-05 00:13:20\",\"created_by\":\"301\",\"created_by_alias\":\"\",\"modified\":\"2019-02-26 19:15:02\",\"modified_by\":\"301\",\"checked_out\":\"0\",\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2019-02-05 00:13:20\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":17,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"217\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('586', '6', '1', '', '2019-02-26 19:21:26', '301', '15965', '231abea4c5e73e1491049365d5c28a139ba31da9', '{\"id\":\"6\",\"asset_id\":\"68\",\"title\":\"Contact\",\"alias\":\"contact\",\"introtext\":\"<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<img src=\\\"images\\/EB-Images\\/Contact\\/ElaineBroe_Contact-OverlappingThoughtBubbles-Graphic.png\\\" alt=\\\"\\\">\\n<h6>&nbsp;<br \\/>&nbsp;<\\/h6>\\n<h3>Contact me.<\\/h3>\\n<h3><p><span style=\\\"font-size: 42px; line-height: 1.2em;\\\">Contact me.<\\/span><\\/p><\\/h3>\\n<h2><p><span style=\\\"font-size: 36px; line-height: 1.2em;\\\">Contact me.<\\/span><\\/p><\\/h2>\\n<div><p>Let\\u2019s get those changes started.<\\/p><\\/div>\\n<div><p><span style=\\\"font-size: 24px;\\\">Let\\u2019s get those changes started.<\\/span><\\/p><\\/div>\\n<div><p><span style=\\\"font-size: 28px; line-height: 34px;\\\">Let\\u2019s get those changes started.<\\/span><\\/p><\\/div>\\n<h2>ELAINE BROE<\\/h2>\\n<ul>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Contact\\/Email-Icon.png\\\" alt=\\\"\\\">\\n\\n<a href=\\\"mailto:info@elainebroe.com\\\"><p class=\\\"uk-text-large\\\"><span style=\\\"color: #000000;\\\">info@elainebroe.com<\\/span><\\/p><\\/a>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Contact\\/LinkedIn-Icon.png\\\" alt=\\\"\\\">\\n\\n<a href=\\\"https:\\/\\/www.linkedin.com\\/in\\/elaine-broe-18540b13\\/\\\"><p class=\\\"uk-text-large\\\"><span style=\\\"color: #000000;\\\">LinkedIn<\\/span><\\/p><\\/a>\\n\\n    <\\/li>\\n    <\\/ul>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Spacer.png\\\" alt=\\\"\\\">\\n\",\"fulltext\":\"<!-- {\\\"name\\\":\\\"About - Page\\\",\\\"type\\\":\\\"layout\\\",\\\"children\\\":[{\\\"name\\\":\\\"TopBanner-Section\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"bottom-left\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"dark\\\",\\\"animation\\\":\\\"fade\\\",\\\"padding_remove_bottom\\\":true,\\\"padding_remove_top\\\":true,\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_width\\\":\\\"700\\\",\\\"image_height\\\":\\\"400\\\",\\\"overlap\\\":false,\\\"css\\\":\\\".el-section {\\\\n    background-color: #F8925E;\\\\n}\\\\n\\\\n@media only screen and (min-width: 1250px) {\\\\n.el-section {\\\\n    min-height: 638px;\\\\n}\\\\n\\\\n.uk-grid {\\\\n    min-height: 638px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1249px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 550px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1000px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 350px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"s\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"expand\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"margin_remove_bottom\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_ContactGraphic-OverlappingThoughtBubbles02.png\\\",\\\"image_size\\\":\\\"contain\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"m\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_height\\\":\\\"\\\",\\\"image_parallax_breakpoint\\\":\\\"\\\",\\\"image_parallax_bgx_start\\\":\\\"\\\",\\\"image_parallax_bgy_start\\\":\\\"70\\\",\\\"image_width\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"Image uk-visible@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"-55\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-20\\\",\\\"parallax_x_end\\\":\\\"-20\\\",\\\"parallax_y_end\\\":\\\"-55\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Image uk-hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"15\\\",\\\"class\\\":\\\"uk-hidden@m\\\",\\\"margin_remove_bottom\\\":true,\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-5\\\",\\\"parallax_x_end\\\":\\\"-5\\\",\\\"parallax_y_end\\\":\\\"15\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Top Graphic hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"remove-vertical\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_Contact-OverlappingThoughtBubbles-Graphic.png\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden@m\\\",\\\"image_width\\\":\\\"250\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"light\\\",\\\"padding\\\":\\\"none\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  \\\\n  \\\\n  padding-left: 120px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 20px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\\n\\\\n\\\\n.uk-tile-default {\\\\n    background: rgba(255, 255, 255, 0.0);\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"spacer @desktop\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h6\\\",\\\"title_style\\\":\\\"heading-hero\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"&nbsp;<br \\\\\\/>&nbsp;\\\",\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden\\\",\\\"margin_remove_top\\\":true}},{\\\"name\\\":\\\"Headline @L\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Contact me.\\\",\\\"class\\\":\\\"uk-light uk-visible@l hidden@m\\\"}},{\\\"name\\\":\\\"Headline @M\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 42px; line-height: 1.2em;\\\\\\\">Contact me.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@m uk-hidden@l\\\"}},{\\\"name\\\":\\\"Headline @S\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h3\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"left\\\",\\\"text_align_breakpoint\\\":\\\"s\\\",\\\"text_align_fallback\\\":\\\"center\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 36px; line-height: 1.2em;\\\\\\\">Contact me.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-hidden@m uk-light\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true}},{\\\"name\\\":\\\"Text @S hidden@s\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"small\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>Let\\\\u2019s get those changes started.<\\\\\\/p>\\\",\\\"class\\\":\\\"uk-hidden@m uk-light uk-visible@s\\\",\\\"margin_remove_bottom\\\":false}},{\\\"name\\\":\\\"Text @M\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"small\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 24px;\\\\\\\">Let\\\\u2019s get those changes started.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@m uk-hidden@l\\\",\\\"margin_remove_bottom\\\":false}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 28px; line-height: 34px;\\\\\\\">Let\\\\u2019s get those changes started.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@l\\\"}}]}]}]},{\\\"name\\\":\\\"Intro Text-PictureBlock\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"padding_remove_top\\\":false,\\\"padding_remove_bottom\\\":false,\\\"css\\\":\\\".el-section {\\\\n    background-color: #F8925E;\\\\n    \\\\n}\\\\n\\\\n@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 90px;\\\\n  padding-right: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n  padding-right: 30px;\\\\n}\\\\n}\\\",\\\"image_effect\\\":\\\"\\\",\\\"animation_delay\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"collapse\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true,\\\"divider\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"muted\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 45px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"slide-left-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"ELAINE BROE\\\",\\\"css\\\":\\\"\\\"}},{\\\"type\\\":\\\"list\\\",\\\"props\\\":{\\\"show_image\\\":true,\\\"show_link\\\":true,\\\"image_align\\\":\\\"left\\\",\\\"image_vertical_align\\\":false,\\\"list_style\\\":\\\"\\\",\\\"content_style\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"icon_color\\\":\\\"\\\",\\\"link_style\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"},\\\"children\\\":[{\\\"type\\\":\\\"list_item\\\",\\\"props\\\":{\\\"icon_color\\\":\\\"\\\",\\\"content\\\":\\\"<p class=\\\\\\\"uk-text-large\\\\\\\"><span style=\\\\\\\"color: #000000;\\\\\\\">info@elainebroe.com<\\\\\\/span><\\\\\\/p>\\\",\\\"icon\\\":\\\"\\\",\\\"link\\\":\\\"mailto:info@elainebroe.com\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/Email-Icon.png\\\"}},{\\\"type\\\":\\\"list_item\\\",\\\"props\\\":{\\\"icon_color\\\":\\\"\\\",\\\"content\\\":\\\"<p class=\\\\\\\"uk-text-large\\\\\\\"><span style=\\\\\\\"color: #000000;\\\\\\\">LinkedIn<\\\\\\/span><\\\\\\/p>\\\",\\\"icon\\\":\\\"\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.linkedin.com\\\\\\/in\\\\\\/elaine-broe-18540b13\\\\\\/\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/LinkedIn-Icon.png\\\",\\\"link_target\\\":true}}]}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-left\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_CoachingElaineSmiles04.jpg\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Spacer.png\\\"}}]}]}]}],\\\"version\\\":\\\"1.18.10\\\",\\\"props\\\":[]} -->\",\"state\":\"1\",\"catid\":\"2\",\"created\":\"2019-02-05 00:13:20\",\"created_by\":\"301\",\"created_by_alias\":\"\",\"modified\":\"2019-02-26 19:21:26\",\"modified_by\":\"301\",\"checked_out\":\"0\",\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2019-02-05 00:13:20\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":18,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"220\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('658', '6', '1', '', '2019-02-28 19:21:22', '301', '15919', 'b61f7b5b536600e8efae60c378deef350f188db8', '{\"id\":\"6\",\"asset_id\":\"68\",\"title\":\"Contact\",\"alias\":\"contact\",\"introtext\":\"<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<img src=\\\"images\\/EB-Images\\/Contact\\/ElaineBroe_Contact-OverlappingThoughtBubbles-Graphic.png\\\" alt=\\\"\\\">\\n<h6>&nbsp;<br \\/>&nbsp;<\\/h6>\\n<h3>Contact me.<\\/h3>\\n<h3><p><span style=\\\"font-size: 42px; line-height: 1.2em;\\\">Contact me.<\\/span><\\/p><\\/h3>\\n<h2><p><span style=\\\"font-size: 36px; line-height: 1.2em;\\\">Contact me.<\\/span><\\/p><\\/h2>\\n<div><p>Let\\u2019s get those changes started.<\\/p><\\/div>\\n<div><p><span style=\\\"font-size: 24px;\\\">Let\\u2019s get those changes started.<\\/span><\\/p><\\/div>\\n<div><p><span style=\\\"font-size: 28px; line-height: 34px;\\\">Let\\u2019s get those changes started.<\\/span><\\/p><\\/div>\\n<h2>ELAINE BROE<\\/h2>\\n<ul>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Contact\\/Email-Icon.png\\\" alt=\\\"\\\">\\n\\n<a href=\\\"mailto:info@elainebroe.com\\\"><p class=\\\"uk-text-large\\\"><span style=\\\"color: #000000;\\\">info@elainebroe.com<\\/span><\\/p><\\/a>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Contact\\/LinkedIn-Icon.png\\\" alt=\\\"\\\">\\n\\n<a href=\\\"https:\\/\\/www.linkedin.com\\/in\\/elaine-broe-18540b13\\/\\\"><p class=\\\"uk-text-large\\\"><span style=\\\"color: #000000;\\\">LinkedIn<\\/span><\\/p><\\/a>\\n\\n    <\\/li>\\n    <\\/ul>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Spacer.png\\\" alt=\\\"\\\">\\n\",\"fulltext\":\"<!-- {\\\"name\\\":\\\"About - Page\\\",\\\"type\\\":\\\"layout\\\",\\\"children\\\":[{\\\"name\\\":\\\"TopBanner-Section\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"bottom-left\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"dark\\\",\\\"animation\\\":\\\"fade\\\",\\\"padding_remove_bottom\\\":true,\\\"padding_remove_top\\\":true,\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_width\\\":\\\"700\\\",\\\"image_height\\\":\\\"400\\\",\\\"overlap\\\":false,\\\"css\\\":\\\".el-section {\\\\n    background-color: #F8925E;\\\\n}\\\\n\\\\n@media only screen and (min-width: 1250px) {\\\\n.el-section {\\\\n    min-height: 638px;\\\\n}\\\\n\\\\n.uk-grid {\\\\n    min-height: 638px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1249px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 550px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1000px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 350px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"s\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"expand\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"margin_remove_bottom\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_ContactGraphic-OverlappingThoughtBubbles02.png\\\",\\\"image_size\\\":\\\"contain\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"m\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_height\\\":\\\"\\\",\\\"image_parallax_breakpoint\\\":\\\"\\\",\\\"image_parallax_bgx_start\\\":\\\"\\\",\\\"image_parallax_bgy_start\\\":\\\"70\\\",\\\"image_width\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"Image uk-visible@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"-55\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-20\\\",\\\"parallax_x_end\\\":\\\"-20\\\",\\\"parallax_y_end\\\":\\\"-55\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Image uk-hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"15\\\",\\\"class\\\":\\\"uk-hidden@m\\\",\\\"margin_remove_bottom\\\":true,\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-5\\\",\\\"parallax_x_end\\\":\\\"-5\\\",\\\"parallax_y_end\\\":\\\"15\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Top Graphic hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"remove-vertical\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_Contact-OverlappingThoughtBubbles-Graphic.png\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden@m\\\",\\\"image_width\\\":\\\"250\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"light\\\",\\\"padding\\\":\\\"none\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  \\\\n  \\\\n  padding-left: 120px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n \\\\n  padding-left: 20px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\\n\\\\n\\\\n.uk-tile-default {\\\\n    background: rgba(255, 255, 255, 0.0);\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"spacer @desktop\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h6\\\",\\\"title_style\\\":\\\"heading-hero\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"&nbsp;<br \\\\\\/>&nbsp;\\\",\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden\\\",\\\"margin_remove_top\\\":true}},{\\\"name\\\":\\\"Headline @L\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Contact me.\\\",\\\"class\\\":\\\"uk-light uk-visible@l hidden@m\\\"}},{\\\"name\\\":\\\"Headline @M\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 42px; line-height: 1.2em;\\\\\\\">Contact me.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@m uk-hidden@l\\\"}},{\\\"name\\\":\\\"Headline @S\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h3\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"left\\\",\\\"text_align_breakpoint\\\":\\\"s\\\",\\\"text_align_fallback\\\":\\\"center\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 36px; line-height: 1.2em;\\\\\\\">Contact me.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-hidden@m uk-light\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true}},{\\\"name\\\":\\\"Text @S hidden@s\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"small\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>Let\\\\u2019s get those changes started.<\\\\\\/p>\\\",\\\"class\\\":\\\"uk-hidden@m uk-light uk-visible@s\\\",\\\"margin_remove_bottom\\\":false}},{\\\"name\\\":\\\"Text @M\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"small\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 24px;\\\\\\\">Let\\\\u2019s get those changes started.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@m uk-hidden@l\\\",\\\"margin_remove_bottom\\\":false}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 28px; line-height: 34px;\\\\\\\">Let\\\\u2019s get those changes started.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@l\\\"}}]}]}]},{\\\"name\\\":\\\"Intro Text-PictureBlock\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"padding_remove_top\\\":false,\\\"padding_remove_bottom\\\":false,\\\"css\\\":\\\".el-section {\\\\n    background-color: #F8925E;\\\\n    \\\\n}\\\\n\\\\n@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 90px;\\\\n  padding-right: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n  padding-right: 30px;\\\\n}\\\\n}\\\",\\\"image_effect\\\":\\\"\\\",\\\"animation_delay\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"collapse\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true,\\\"divider\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"muted\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 45px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"slide-left-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"ELAINE BROE\\\",\\\"css\\\":\\\"\\\"}},{\\\"type\\\":\\\"list\\\",\\\"props\\\":{\\\"show_image\\\":true,\\\"show_link\\\":true,\\\"image_align\\\":\\\"left\\\",\\\"image_vertical_align\\\":false,\\\"list_style\\\":\\\"\\\",\\\"content_style\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"icon_color\\\":\\\"\\\",\\\"link_style\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"},\\\"children\\\":[{\\\"type\\\":\\\"list_item\\\",\\\"props\\\":{\\\"icon_color\\\":\\\"\\\",\\\"content\\\":\\\"<p class=\\\\\\\"uk-text-large\\\\\\\"><span style=\\\\\\\"color: #000000;\\\\\\\">info@elainebroe.com<\\\\\\/span><\\\\\\/p>\\\",\\\"icon\\\":\\\"\\\",\\\"link\\\":\\\"mailto:info@elainebroe.com\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/Email-Icon.png\\\"}},{\\\"type\\\":\\\"list_item\\\",\\\"props\\\":{\\\"icon_color\\\":\\\"\\\",\\\"content\\\":\\\"<p class=\\\\\\\"uk-text-large\\\\\\\"><span style=\\\\\\\"color: #000000;\\\\\\\">LinkedIn<\\\\\\/span><\\\\\\/p>\\\",\\\"icon\\\":\\\"\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.linkedin.com\\\\\\/in\\\\\\/elaine-broe-18540b13\\\\\\/\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/LinkedIn-Icon.png\\\",\\\"link_target\\\":true}}]}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-left\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_CoachingElaineSmiles04.jpg\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Spacer.png\\\"}}]}]}]}],\\\"version\\\":\\\"1.18.10\\\",\\\"props\\\":[]} -->\",\"state\":\"1\",\"catid\":\"2\",\"created\":\"2019-02-05 00:13:20\",\"created_by\":\"301\",\"created_by_alias\":\"\",\"modified\":\"2019-02-28 19:21:22\",\"modified_by\":\"301\",\"checked_out\":\"0\",\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2019-02-05 00:13:20\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":19,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"231\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('659', '6', '1', '', '2019-02-28 19:22:25', '301', '15919', 'b9adf423946c227332688e295237823a81ff9272', '{\"id\":\"6\",\"asset_id\":\"68\",\"title\":\"Contact\",\"alias\":\"contact\",\"introtext\":\"<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<img src=\\\"images\\/EB-Images\\/Contact\\/ElaineBroe_Contact-OverlappingThoughtBubbles-Graphic.png\\\" alt=\\\"\\\">\\n<h6>&nbsp;<br \\/>&nbsp;<\\/h6>\\n<h3>Contact me.<\\/h3>\\n<h3><p><span style=\\\"font-size: 42px; line-height: 1.2em;\\\">Contact me.<\\/span><\\/p><\\/h3>\\n<h2><p><span style=\\\"font-size: 36px; line-height: 1.1em;\\\">Contact me.<\\/span><\\/p><\\/h2>\\n<div><p>Let\\u2019s get those changes started.<\\/p><\\/div>\\n<div><p><span style=\\\"font-size: 24px;\\\">Let\\u2019s get those changes started.<\\/span><\\/p><\\/div>\\n<div><p><span style=\\\"font-size: 28px; line-height: 34px;\\\">Let\\u2019s get those changes started.<\\/span><\\/p><\\/div>\\n<h2>ELAINE BROE<\\/h2>\\n<ul>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Contact\\/Email-Icon.png\\\" alt=\\\"\\\">\\n\\n<a href=\\\"mailto:info@elainebroe.com\\\"><p class=\\\"uk-text-large\\\"><span style=\\\"color: #000000;\\\">info@elainebroe.com<\\/span><\\/p><\\/a>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Contact\\/LinkedIn-Icon.png\\\" alt=\\\"\\\">\\n\\n<a href=\\\"https:\\/\\/www.linkedin.com\\/in\\/elaine-broe-18540b13\\/\\\"><p class=\\\"uk-text-large\\\"><span style=\\\"color: #000000;\\\">LinkedIn<\\/span><\\/p><\\/a>\\n\\n    <\\/li>\\n    <\\/ul>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Spacer.png\\\" alt=\\\"\\\">\\n\",\"fulltext\":\"<!-- {\\\"name\\\":\\\"About - Page\\\",\\\"type\\\":\\\"layout\\\",\\\"children\\\":[{\\\"name\\\":\\\"TopBanner-Section\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"bottom-left\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"dark\\\",\\\"animation\\\":\\\"fade\\\",\\\"padding_remove_bottom\\\":true,\\\"padding_remove_top\\\":true,\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_width\\\":\\\"700\\\",\\\"image_height\\\":\\\"400\\\",\\\"overlap\\\":false,\\\"css\\\":\\\".el-section {\\\\n    background-color: #F8925E;\\\\n}\\\\n\\\\n@media only screen and (min-width: 1250px) {\\\\n.el-section {\\\\n    min-height: 638px;\\\\n}\\\\n\\\\n.uk-grid {\\\\n    min-height: 638px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1249px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 550px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1000px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 350px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"s\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"expand\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"margin_remove_bottom\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_ContactGraphic-OverlappingThoughtBubbles02.png\\\",\\\"image_size\\\":\\\"contain\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"m\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_height\\\":\\\"\\\",\\\"image_parallax_breakpoint\\\":\\\"\\\",\\\"image_parallax_bgx_start\\\":\\\"\\\",\\\"image_parallax_bgy_start\\\":\\\"70\\\",\\\"image_width\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"Image uk-visible@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"-55\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-20\\\",\\\"parallax_x_end\\\":\\\"-20\\\",\\\"parallax_y_end\\\":\\\"-55\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Image uk-hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"15\\\",\\\"class\\\":\\\"uk-hidden@m\\\",\\\"margin_remove_bottom\\\":true,\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-5\\\",\\\"parallax_x_end\\\":\\\"-5\\\",\\\"parallax_y_end\\\":\\\"15\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Top Graphic hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"remove-vertical\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_Contact-OverlappingThoughtBubbles-Graphic.png\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden@m\\\",\\\"image_width\\\":\\\"250\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"light\\\",\\\"padding\\\":\\\"none\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  \\\\n  \\\\n  padding-left: 120px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n \\\\n  padding-left: 20px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\\n\\\\n\\\\n.uk-tile-default {\\\\n    background: rgba(255, 255, 255, 0.0);\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"spacer @desktop\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h6\\\",\\\"title_style\\\":\\\"heading-hero\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"&nbsp;<br \\\\\\/>&nbsp;\\\",\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden\\\",\\\"margin_remove_top\\\":true}},{\\\"name\\\":\\\"Headline @L\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Contact me.\\\",\\\"class\\\":\\\"uk-light uk-visible@l hidden@m\\\"}},{\\\"name\\\":\\\"Headline @M\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 42px; line-height: 1.2em;\\\\\\\">Contact me.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@m uk-hidden@l\\\"}},{\\\"name\\\":\\\"Headline @S\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h3\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"left\\\",\\\"text_align_breakpoint\\\":\\\"s\\\",\\\"text_align_fallback\\\":\\\"center\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 36px; line-height: 1.1em;\\\\\\\">Contact me.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-hidden@m uk-light\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true}},{\\\"name\\\":\\\"Text @S hidden@s\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"small\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>Let\\\\u2019s get those changes started.<\\\\\\/p>\\\",\\\"class\\\":\\\"uk-hidden@m uk-light uk-visible@s\\\",\\\"margin_remove_bottom\\\":false}},{\\\"name\\\":\\\"Text @M\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"small\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 24px;\\\\\\\">Let\\\\u2019s get those changes started.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@m uk-hidden@l\\\",\\\"margin_remove_bottom\\\":false}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 28px; line-height: 34px;\\\\\\\">Let\\\\u2019s get those changes started.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@l\\\"}}]}]}]},{\\\"name\\\":\\\"Intro Text-PictureBlock\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"padding_remove_top\\\":false,\\\"padding_remove_bottom\\\":false,\\\"css\\\":\\\".el-section {\\\\n    background-color: #F8925E;\\\\n    \\\\n}\\\\n\\\\n@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 90px;\\\\n  padding-right: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n  padding-right: 30px;\\\\n}\\\\n}\\\",\\\"image_effect\\\":\\\"\\\",\\\"animation_delay\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"collapse\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true,\\\"divider\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"muted\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 45px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"slide-left-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"ELAINE BROE\\\",\\\"css\\\":\\\"\\\"}},{\\\"type\\\":\\\"list\\\",\\\"props\\\":{\\\"show_image\\\":true,\\\"show_link\\\":true,\\\"image_align\\\":\\\"left\\\",\\\"image_vertical_align\\\":false,\\\"list_style\\\":\\\"\\\",\\\"content_style\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"icon_color\\\":\\\"\\\",\\\"link_style\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"},\\\"children\\\":[{\\\"type\\\":\\\"list_item\\\",\\\"props\\\":{\\\"icon_color\\\":\\\"\\\",\\\"content\\\":\\\"<p class=\\\\\\\"uk-text-large\\\\\\\"><span style=\\\\\\\"color: #000000;\\\\\\\">info@elainebroe.com<\\\\\\/span><\\\\\\/p>\\\",\\\"icon\\\":\\\"\\\",\\\"link\\\":\\\"mailto:info@elainebroe.com\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/Email-Icon.png\\\"}},{\\\"type\\\":\\\"list_item\\\",\\\"props\\\":{\\\"icon_color\\\":\\\"\\\",\\\"content\\\":\\\"<p class=\\\\\\\"uk-text-large\\\\\\\"><span style=\\\\\\\"color: #000000;\\\\\\\">LinkedIn<\\\\\\/span><\\\\\\/p>\\\",\\\"icon\\\":\\\"\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.linkedin.com\\\\\\/in\\\\\\/elaine-broe-18540b13\\\\\\/\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/LinkedIn-Icon.png\\\",\\\"link_target\\\":true}}]}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-left\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Contact\\\\\\/ElaineBroe_CoachingElaineSmiles04.jpg\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Spacer.png\\\"}}]}]}]}],\\\"version\\\":\\\"1.18.10\\\",\\\"props\\\":[]} -->\",\"state\":\"1\",\"catid\":\"2\",\"created\":\"2019-02-05 00:13:20\",\"created_by\":\"301\",\"created_by_alias\":\"\",\"modified\":\"2019-02-28 19:22:25\",\"modified_by\":\"301\",\"checked_out\":\"0\",\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2019-02-05 00:13:20\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":20,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"233\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('672', '1', '1', '', '2019-02-28 19:47:25', '301', '54717', '8621f278eff454a2342102c741d8a4f348000528', '{\"id\":\"1\",\"asset_id\":\"63\",\"title\":\"home\",\"alias\":\"home\",\"introtext\":\"<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_HomeGraphic-SharedIdeasCollaboration-mobile.png\\\" alt=\\\"\\\">\\n<h6>&nbsp;<br \\/>&nbsp;<\\/h6>\\n<h3>Uncover possibilities<br \\/> that seem just beyond<br \\/> reach... one good conversation at a time.<\\/h3>\\n<h3><p><span style=\\\"font-size: 42px; line-height: 1.2em;\\\">Uncover possibilities<br \\/> that seem just beyond<br \\/> reach... one good conversation at a time.<\\/span><\\/p><\\/h3>\\n<h2><span style=\\\"font-size: 36px; line-height: 1.1em;\\\">Uncover possibilities that seem just beyond reach... one good conversation at a time.<\\/span><\\/h2>\\n<div><p>Create connection. Use laughter. Imagine change. Make a plan. This is how we shape strong teams and good leaders. I will help you learn how.<\\/p><\\/div>\\n<div><p><span style=\\\"font-size: 22pt; line-height: 22pt;\\\">Create connection. Use laughter. Imagine change. Make a plan. This is how we shape strong teams and good leaders. I will help you learn how.<\\/span><\\/p><\\/div>\\n<h2>EXPERIENCE IS EVERYTHING<\\/h2>\\n<div><div class=\\\"uk-visible@m\\\">I design & deliver tailored, transformative leadership and learning experiences for people, brands and businesses.<br><br>\\nWhether you\\u2019re part of a Fortune 500 company or a lone entrepreneur, I help uncover what matters most, and work closely with you to design the best solution.<\\/div>\\n\\n<div class=\\\"uk-hidden@m\\\"><span style=\\\"font-size: 22px; line-height: 1.25em;\\\">I design & deliver tailored, transformative leadership and learning experiences for people, brands and businesses.<br><br>\\nWhether you\\u2019re part of a Fortune 500 company or a lone entrepreneur, I help uncover what matters most, and work closely with you to design the best solution.<\\/span><\\/div><\\/div>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Spacer.png\\\" alt=\\\"\\\">\\n<h1>&nbsp;<br \\/>&nbsp;<\\/h1>\\n<h2>WHAT I BELIEVE<\\/h2>\\n<div><p><span style=\\\"color: #333333;\\\">The average person will spend 90,000 hours at work over a lifetime. I know, I had to sit down when I read it too. Work and life are not separate, which is why your life\\u2019s work needs to be a priority. We have an opportunity to go beyond daily survival skills and practice new ways to be confident, kind and successful humans in the world. That\\u2019s the work I do.<\\/span><\\/p><\\/div>\\n<h2>Here\\u2019s what it\\u2019s like to work with me:<\\/h2>\\n<div>\\u201cI know firsthand the positive impact Elaine has within organizations and I can always count on her to deliver. She is an expert in her field who I have seen bring out the best in the teams she works with. Elaine is a triple threat; designer, facilitator and leadership subject expert who brings a unique ability to create solutions for organizations.\\u201d\\n<\\/div>\\n<h4>JANEEN SPEER, VP TALENT<br>\\nSHOPIFY<\\/h4>\\n<div><p>\\u201cI have worked with hundreds of people who do what she does, both coaches and facilitators, and Elaine stands above them all. She is excellent at the many ways in which she supports clients and organizations. She is not like the rest, Elaine is in a league of her own.\\u201d<\\/p><\\/div>\\n<h4>SARAH DICKINSON, CO-FOUNDER AND MANAGING DIRECTOR<br>\\nTHNK SCHOOL OF CREATIVE LEADERSHIP<\\/h4>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_HomeQuotesGraphic.jpg\\\" alt=\\\"\\\">\\n<div><p>\\u201cThere I was, minding my own business taking an Executive Leadership Program and in front of the room, blowing my mind, was Elaine. She took us on a journey to shake us up and lead us through establishing a culture for innovative thinking while we laughed our way through design thinking exercises day after day. Mission fulfilled. At the end, I felt like the guy who loved the product so much I bought the company, but in this case I bought a little more of Elaine\'s time for my company.<\\/p>\\n<p>Currently with CAGR of 20% over the last four years, 2,000 employees and $1\\/2 Billion in managed assets, Innisfree is a dynamic, and growing organization. After Elaine\\u2019s first year with Innisfree\'s leadership team, I quickly came to the realization that I have done us a tremendous favor. Elaine has led Innisfree senior management through several iterations to begin the sea change of culture toward a more innovative environment.\\u201d\\n<\\/p><\\/div>\\n<h4>JULIAN MACQUEEN, CHAIRMAN & FOUNDER<br>\\nINNISFREE HOTELS<\\/h4>\\n<h2>Here\\u2019s what it\\u2019s like to work with me:<\\/h2>\\n<div><p>\\u201cThere I was, minding my own business taking an Executive Leadership Program and in front of the room, blowing my mind, was Elaine. She took us on a journey to shake us up and lead us through establishing a culture for innovative thinking while we laughed our way through design thinking exercises day after day. Mission fulfilled. At the end, I felt like the guy who loved the product so much I bought the company, but in this case I bought a little more of Elaine\'s time for my company.<\\/p>\\n<p>Currently with CAGR of 20% over the last four years, 2,000 employees and $1\\/2 Billion in managed assets, Innisfree is a dynamic, and growing organization. After Elaine\\u2019s first year with Innisfree\'s leadership team, I quickly came to the realization that I have done us a tremendous favor. Elaine has led Innisfree senior management through several iterations to begin the sea change of culture toward a more innovative environment.\\u201d\\n<\\/p><\\/div>\\n<h4>JULIAN MACQUEEN, CHAIRMAN & FOUNDER<br>\\nINNISFREE HOTELS<\\/h4>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_HomeTalkingHeadsGraphic2.png\\\" alt=\\\"\\\">\\n<h2>Tailor-made<br>\\nLeadership Experiences<\\/h2>\\n<div>You have the time, the budget and the desire to shape a memorable experience for your people. Your culture is distinct and you want a tailored solution to get to the next level. You\\u2019re seeking a skilled partner who gets you and your people. The good, the bad and the \\u201cyeah we really need to deal with that\\u201d parts of your organization.<\\/div>\\n<p>\\n    <a href=\\\"tailor-made-leadership\\\">Learn More<\\/a>\\n<\\/p>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Home-GroupCircleGraphic2.png\\\" alt=\\\"\\\">\\n<h2>Ready-made<br>\\nLearning Experiences<\\/h2>\\n<div>Your team or conference guests are in need of an inspired approach to evolve the way they think and lead. I promise I\\u2019ve never had anyone fall asleep, and I like a challenge. You\\u2019ll get experienced design and a waiting list of people who want to sign up. This catalogue provides solutions to enliven learning and connection with any group. Yes, even those groups.<\\/div>\\n<p>\\n    <a href=\\\"ready-made-learning\\\">Learn More<\\/a>\\n<\\/p>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Home-HighFiveGraphic3.png\\\" alt=\\\"\\\">\\n<h2>One-to-one<br>\\nExecutive Coaching<\\/h2>\\n<div>You\\u2019ve got big ideas, tricky team dynamics or changes to lead. I\\u2019m skilled, caring, and will challenge that voice inside your head, you know the one. Set time aside to prioritize thoughtful reflection with an experienced advisor. I coach a select group of leaders and entrepreneurs who do the work to get results, and happen to have a good sense of humour, as well.<\\/div>\\n<p>\\n    <a href=\\\"one-to-one-coaching\\\">Learn More<\\/a>\\n<\\/p>\\n<h2>ELAINE IS LOVED BY THESE COMPANIES, AND MORE.<\\/h2>\\n<ul>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-Westjet.png\\\" alt=\\\"\\\">\\n\\n<h3>Westjet Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/www.westjet.com\\/en-ca\\/index\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-Banff-Centre.png\\\" alt=\\\"\\\">\\n\\n<h3>Banff Centre Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/www.banffcentre.ca\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-THNK-Leadership.png\\\" alt=\\\"\\\">\\n\\n<h3>THNK Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/www.thnk.org\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-Lululemon.png\\\" alt=\\\"\\\">\\n\\n<h3>Lululemon Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/shop.lululemon.com\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-MEC.png\\\" alt=\\\"\\\">\\n\\n<h3>MEC Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/www.mec.ca\\/en\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-GoPro.png\\\" alt=\\\"\\\">\\n\\n<h3>Go Pro Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/gopro.com\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n    <\\/ul>\\n\",\"fulltext\":\"<!-- {\\\"name\\\":\\\"Home Page v2\\\",\\\"type\\\":\\\"layout\\\",\\\"children\\\":[{\\\"name\\\":\\\"Hero\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"primary\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"bottom-left\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"dark\\\",\\\"animation\\\":\\\"fade\\\",\\\"padding_remove_bottom\\\":true,\\\"padding_remove_top\\\":true,\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_width\\\":\\\"700\\\",\\\"image_height\\\":\\\"400\\\",\\\"overlap\\\":false,\\\"css\\\":\\\"@media only screen and (min-width: 1250px) {\\\\n.el-section {\\\\n    min-height: 638px;\\\\n}\\\\n\\\\n.uk-grid {\\\\n    min-height: 638px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1249px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 550px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1000px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 350px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"s\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"expand\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"margin_remove_bottom\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"bottom-right\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeGraphic-SharedIdeasCollaboration_1x1Right.png\\\",\\\"image_size\\\":\\\"contain\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"m\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_height\\\":\\\"\\\",\\\"image_parallax_breakpoint\\\":\\\"\\\",\\\"image_parallax_bgx_start\\\":\\\"\\\",\\\"image_parallax_bgy_start\\\":\\\"70\\\",\\\"image_width\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"Image uk-visible@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"-55\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-20\\\",\\\"parallax_x_end\\\":\\\"-20\\\",\\\"parallax_y_end\\\":\\\"-55\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Image uk-hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"15\\\",\\\"class\\\":\\\"uk-hidden@m\\\",\\\"margin_remove_bottom\\\":true,\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-5\\\",\\\"parallax_x_end\\\":\\\"-5\\\",\\\"parallax_y_end\\\":\\\"15\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Top Graphic hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeGraphic-SharedIdeasCollaboration-mobile.png\\\",\\\"margin_remove_top\\\":false,\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden@m\\\",\\\"image_width\\\":\\\"250\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"light\\\",\\\"padding\\\":\\\"none\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  \\\\n  \\\\n  padding-left: 120px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n\\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n  padding-bottom: 20px;\\\\n}\\\\n}\\\\n\\\\n\\\\n.uk-tile-default {\\\\n    background: rgba(255, 255, 255, 0.0);\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"spacer @desktop\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h6\\\",\\\"title_style\\\":\\\"heading-hero\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"&nbsp;<br \\\\\\/>&nbsp;\\\",\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden\\\",\\\"margin_remove_top\\\":true}},{\\\"name\\\":\\\"Headline @L\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Uncover possibilities<br \\\\\\/> that seem just beyond<br \\\\\\/> reach... one good conversation at a time.\\\",\\\"class\\\":\\\"uk-light uk-visible@l hidden@m\\\"}},{\\\"name\\\":\\\"Headline @M\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 42px; line-height: 1.2em;\\\\\\\">Uncover possibilities<br \\\\\\/> that seem just beyond<br \\\\\\/> reach... one good conversation at a time.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@m uk-hidden@l\\\"}},{\\\"name\\\":\\\"Headline @S\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h3\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<span style=\\\\\\\"font-size: 36px; line-height: 1.1em;\\\\\\\">Uncover possibilities that seem just beyond reach... one good conversation at a time.<\\\\\\/span>\\\",\\\"class\\\":\\\"uk-hidden@m uk-light\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true}},{\\\"name\\\":\\\"Text @S hidden@s\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"small\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>Create connection. Use laughter. Imagine change. Make a plan. This is how we shape strong teams and good leaders. I will help you learn how.<\\\\\\/p>\\\",\\\"class\\\":\\\"uk-hidden@l uk-light uk-visible@m\\\",\\\"margin_remove_bottom\\\":false}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 22pt; line-height: 22pt;\\\\\\\">Create connection. Use laughter. Imagine change. Make a plan. This is how we shape strong teams and good leaders. I will help you learn how.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@l\\\"}}]}]}]},{\\\"name\\\":\\\"Intro\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"padding_remove_top\\\":false,\\\"padding_remove_bottom\\\":false,\\\"css\\\":\\\"\\\",\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true,\\\"divider\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"EXPERIENCE IS EVERYTHING\\\",\\\"css\\\":\\\"\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"large\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<div class=\\\\\\\"uk-visible@m\\\\\\\">I design & deliver tailored, transformative leadership and learning experiences for people, brands and businesses.<br><br>\\\\nWhether you\\\\u2019re part of a Fortune 500 company or a lone entrepreneur, I help uncover what matters most, and work closely with you to design the best solution.<\\\\\\/div>\\\\n\\\\n<div class=\\\\\\\"uk-hidden@m\\\\\\\"><span style=\\\\\\\"font-size: 22px; line-height: 1.25em;\\\\\\\">I design & deliver tailored, transformative leadership and learning experiences for people, brands and businesses.<br><br>\\\\nWhether you\\\\u2019re part of a Fortune 500 company or a lone entrepreneur, I help uncover what matters most, and work closely with you to design the best solution.<\\\\\\/span><\\\\\\/div>\\\",\\\"css\\\":\\\"\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-left\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeClassRoomCollaboration3.jpg\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Spacer.png\\\"}},{\\\"name\\\":\\\"spacer @mobile\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h1\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"&nbsp;<br \\\\\\/>&nbsp;\\\",\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden@s\\\",\\\"margin_remove_top\\\":true}}]}]}]},{\\\"name\\\":\\\"What I believe\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"css\\\":\\\".el-section {\\\\n    background-color: #F8925E;\\\\n    \\\\n}\\\\n\\\\n@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 40px; \\\\n  padding-left: 90px;\\\\n  padding-right: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n  padding-right: 30px;\\\\n}\\\\n}\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"WHAT I BELIEVE\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"large\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"color: #333333;\\\\\\\">The average person will spend 90,000 hours at work over a lifetime. I know, I had to sit down when I read it too. Work and life are not separate, which is why your life\\\\u2019s work needs to be a priority. We have an opportunity to go beyond daily survival skills and practice new ways to be confident, kind and successful humans in the world. That\\\\u2019s the work I do.<\\\\\\/span><\\\\\\/p>\\\"}}]}]}]},{\\\"name\\\":\\\"to work with me @desktop\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"muted\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"css\\\":\\\"\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"margin_remove_bottom\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  padding-top: 50px;\\\\n   \\\\n  padding-left: 115px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  padding-top: 30px;\\\\n   \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"heading-primary\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Here\\\\u2019s what it\\\\u2019s like to work with me:\\\"}}]}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"divider\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  \\\\n  padding-bottom: 60px; \\\\n  padding-left: 115px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  \\\\n  padding-bottom: 30px; \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"\\\\u201cI know firsthand the positive impact Elaine has within organizations and I can always count on her to deliver. She is an expert in her field who I have seen bring out the best in the teams she works with. Elaine is a triple threat; designer, facilitator and leadership subject expert who brings a unique ability to create solutions for organizations.\\\\u201d\\\\n\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h4\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"JANEEN SPEER, VP TALENT<br>\\\\nSHOPIFY\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"divider\\\",\\\"props\\\":{\\\"divider_element\\\":\\\"div\\\",\\\"divider_style\\\":\\\"small\\\",\\\"divider_align\\\":\\\"\\\",\\\"divider_align_breakpoint\\\":\\\"\\\",\\\"divider_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>\\\\u201cI have worked with hundreds of people who do what she does, both coaches and facilitators, and Elaine stands above them all. She is excellent at the many ways in which she supports clients and organizations. She is not like the rest, Elaine is in a league of her own.\\\\u201d<\\\\\\/p>\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h4\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"SARAH DICKINSON, CO-FOUNDER AND MANAGING DIRECTOR<br>\\\\nTHNK SCHOOL OF CREATIVE LEADERSHIP\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"divider\\\",\\\"props\\\":{\\\"divider_element\\\":\\\"div\\\",\\\"divider_style\\\":\\\"small\\\",\\\"divider_align\\\":\\\"\\\",\\\"divider_align_breakpoint\\\":\\\"\\\",\\\"divider_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 45px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\\n\\\\n\\\\\\/* Experimental *\\\\\\/\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"right\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeQuotesGraphic.jpg\\\",\\\"image_height\\\":\\\"50\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>\\\\u201cThere I was, minding my own business taking an Executive Leadership Program and in front of the room, blowing my mind, was Elaine. She took us on a journey to shake us up and lead us through establishing a culture for innovative thinking while we laughed our way through design thinking exercises day after day. Mission fulfilled. At the end, I felt like the guy who loved the product so much I bought the company, but in this case I bought a little more of Elaine\'s time for my company.<\\\\\\/p>\\\\n<p>Currently with CAGR of 20% over the last four years, 2,000 employees and $1\\\\\\/2 Billion in managed assets, Innisfree is a dynamic, and growing organization. After Elaine\\\\u2019s first year with Innisfree\'s leadership team, I quickly came to the realization that I have done us a tremendous favor. Elaine has led Innisfree senior management through several iterations to begin the sea change of culture toward a more innovative environment.\\\\u201d\\\\n<\\\\\\/p>\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h4\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"JULIAN MACQUEEN, CHAIRMAN & FOUNDER<br>\\\\nINNISFREE HOTELS\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"divider\\\",\\\"props\\\":{\\\"divider_element\\\":\\\"div\\\",\\\"divider_style\\\":\\\"small\\\",\\\"divider_align\\\":\\\"\\\",\\\"divider_align_breakpoint\\\":\\\"\\\",\\\"divider_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"}}]}]}]},{\\\"name\\\":\\\"to work with me @mobile\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"muted\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"css\\\":\\\"\\\",\\\"class\\\":\\\"uk-hidden@m\\\",\\\"image_effect\\\":\\\"\\\",\\\"padding_remove_top\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"divider\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 115px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Here\\\\u2019s what it\\\\u2019s like to work with me:\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>\\\\u201cThere I was, minding my own business taking an Executive Leadership Program and in front of the room, blowing my mind, was Elaine. She took us on a journey to shake us up and lead us through establishing a culture for innovative thinking while we laughed our way through design thinking exercises day after day. Mission fulfilled. At the end, I felt like the guy who loved the product so much I bought the company, but in this case I bought a little more of Elaine\'s time for my company.<\\\\\\/p>\\\\n<p>Currently with CAGR of 20% over the last four years, 2,000 employees and $1\\\\\\/2 Billion in managed assets, Innisfree is a dynamic, and growing organization. After Elaine\\\\u2019s first year with Innisfree\'s leadership team, I quickly came to the realization that I have done us a tremendous favor. Elaine has led Innisfree senior management through several iterations to begin the sea change of culture toward a more innovative environment.\\\\u201d\\\\n<\\\\\\/p>\\\",\\\"css\\\":\\\"\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h4\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"JULIAN MACQUEEN, CHAIRMAN & FOUNDER<br>\\\\nINNISFREE HOTELS\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"divider\\\",\\\"props\\\":{\\\"divider_element\\\":\\\"div\\\",\\\"divider_style\\\":\\\"small\\\",\\\"divider_align\\\":\\\"\\\",\\\"divider_align_breakpoint\\\":\\\"\\\",\\\"divider_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"}}]}]}]},{\\\"name\\\":\\\"Services - Tailor Made\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"animation_delay\\\":true,\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"divider\\\":false,\\\"margin_remove_bottom\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\".el-section {\\\\n    background-color: #9CC788;\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"slide-left-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeTalkingHeadsGraphic2.png\\\",\\\"image_height\\\":\\\"505\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"xsmall\\\",\\\"css\\\":\\\"@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n\\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n  padding-bottom: 40px;\\\\n  padding-top: 10px;\\\\n        \\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"heading-primary\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Tailor-made<br>\\\\nLeadership Experiences\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"You have the time, the budget and the desire to shape a memorable experience for your people. Your culture is distinct and you want a tailored solution to get to the next level. You\\\\u2019re seeking a skilled partner who gets you and your people. The good, the bad and the \\\\u201cyeah we really need to deal with that\\\\u201d parts of your organization.\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button\\\",\\\"props\\\":{\\\"gutter\\\":\\\"small\\\",\\\"margin\\\":\\\"default\\\",\\\"button_size\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button_item\\\",\\\"props\\\":{\\\"button_style\\\":\\\"default\\\",\\\"icon_align\\\":\\\"left\\\",\\\"link_target\\\":\\\"\\\",\\\"content\\\":\\\"Learn More\\\",\\\"link\\\":\\\"tailor-made-leadership\\\"}}]}]}]}]},{\\\"name\\\":\\\"Services - Ready-Made\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"animation_delay\\\":true,\\\"css\\\":\\\"@media (min-width: 960px){\\\\n.uk-tile {\\\\n    padding-left: 70px;\\\\n    padding-right: 40px;\\\\n    padding-top: 65px;\\\\n    padding-bottom: 65px;\\\\n}\\\\n}\\\",\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"divider\\\":false,\\\"margin_remove_bottom\\\":true,\\\"order_last\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\".el-section {\\\\n    background-color: #F4EBC6;\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"slide-right-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Home-GroupCircleGraphic2.png\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"heading-primary\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Ready-made<br>\\\\nLearning Experiences\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Your team or conference guests are in need of an inspired approach to evolve the way they think and lead. I promise I\\\\u2019ve never had anyone fall asleep, and I like a challenge. You\\\\u2019ll get experienced design and a waiting list of people who want to sign up. This catalogue provides solutions to enliven learning and connection with any group. Yes, even those groups.\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button\\\",\\\"props\\\":{\\\"gutter\\\":\\\"small\\\",\\\"margin\\\":\\\"default\\\",\\\"button_size\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button_item\\\",\\\"props\\\":{\\\"button_style\\\":\\\"default\\\",\\\"icon_align\\\":\\\"left\\\",\\\"link_target\\\":\\\"\\\",\\\"content\\\":\\\"Learn More\\\",\\\"link\\\":\\\"ready-made-learning\\\"}}]}]}]}]},{\\\"name\\\":\\\"Services - One-to-one\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"animation_delay\\\":true,\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"divider\\\":false,\\\"margin_remove_bottom\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"secondary\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"slide-left-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Home-HighFiveGraphic3.png\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"heading-primary\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"One-to-one<br>\\\\nExecutive Coaching\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"You\\\\u2019ve got big ideas, tricky team dynamics or changes to lead. I\\\\u2019m skilled, caring, and will challenge that voice inside your head, you know the one. Set time aside to prioritize thoughtful reflection with an experienced advisor. I coach a select group of leaders and entrepreneurs who do the work to get results, and happen to have a good sense of humour, as well.\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button\\\",\\\"props\\\":{\\\"gutter\\\":\\\"small\\\",\\\"margin\\\":\\\"default\\\",\\\"button_size\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button_item\\\",\\\"props\\\":{\\\"button_style\\\":\\\"default\\\",\\\"icon_align\\\":\\\"left\\\",\\\"link_target\\\":\\\"\\\",\\\"content\\\":\\\"Learn More\\\",\\\"link\\\":\\\"one-to-one-coaching\\\"}}]}]}]}]},{\\\"name\\\":\\\"Image Parallax\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"default\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"percent\\\",\\\"padding\\\":\\\"\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeElaineTeachesGroupBW.jpg\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"fixed\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_parallax_breakpoint\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\"}}]}]},{\\\"name\\\":\\\"Clients - Partners\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"slide-top-small\\\",\\\"animation_delay\\\":true,\\\"image_effect\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 90px;\\\\n  padding-right: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    el-section {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n  padding-right: 30px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"large\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"ELAINE IS LOVED BY THESE COMPANIES, AND MORE.\\\",\\\"margin_remove_top\\\":true}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid\\\",\\\"props\\\":{\\\"show_title\\\":false,\\\"show_meta\\\":false,\\\"show_content\\\":false,\\\"show_image\\\":true,\\\"show_link\\\":true,\\\"grid_default\\\":\\\"2\\\",\\\"grid_medium\\\":\\\"3\\\",\\\"filter_style\\\":\\\"tab\\\",\\\"filter_all\\\":true,\\\"filter_position\\\":\\\"top\\\",\\\"filter_align\\\":\\\"left\\\",\\\"filter_grid_width\\\":\\\"auto\\\",\\\"filter_breakpoint\\\":\\\"m\\\",\\\"title_element\\\":\\\"h3\\\",\\\"meta_style\\\":\\\"meta\\\",\\\"meta_align\\\":\\\"bottom\\\",\\\"icon_ratio\\\":4,\\\"image_align\\\":\\\"between\\\",\\\"image_grid_width\\\":\\\"1-2\\\",\\\"image_breakpoint\\\":\\\"m\\\",\\\"link_text\\\":\\\"Read more\\\",\\\"link_style\\\":\\\"panel\\\",\\\"margin\\\":\\\"default\\\",\\\"item_animation\\\":\\\"fade\\\",\\\"gutter\\\":\\\"\\\",\\\"grid_small\\\":\\\"\\\",\\\"grid_large\\\":\\\"6\\\",\\\"grid_xlarge\\\":\\\"6\\\",\\\"filter_margin\\\":\\\"\\\",\\\"filter_gutter\\\":\\\"\\\",\\\"title_display\\\":\\\"\\\",\\\"content_display\\\":\\\"\\\",\\\"panel_style\\\":\\\"\\\",\\\"panel_size\\\":\\\"\\\",\\\"item_maxwidth\\\":\\\"\\\",\\\"title_style\\\":\\\"\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"meta_color\\\":\\\"\\\",\\\"meta_margin\\\":\\\"\\\",\\\"content_style\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"icon_color\\\":\\\"\\\",\\\"image_gutter\\\":\\\"\\\",\\\"link_size\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"link_target\\\":true,\\\"grid_masonry\\\":false,\\\"grid_parallax\\\":\\\"0\\\",\\\"image_height\\\":\\\"65\\\",\\\"divider\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"Westjet Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-Westjet.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.westjet.com\\\\\\/en-ca\\\\\\/index\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"Banff Centre Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-Banff-Centre.png\\\",\\\"image_alt\\\":\\\"\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.banffcentre.ca\\\\\\/\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"THNK Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-THNK-Leadership.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.thnk.org\\\\\\/\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"Lululemon Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-Lululemon.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/shop.lululemon.com\\\\\\/\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"MEC Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-MEC.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.mec.ca\\\\\\/en\\\\\\/\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"Go Pro Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-GoPro.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/gopro.com\\\\\\/\\\"}}]}]}]}]}],\\\"props\\\":[],\\\"version\\\":\\\"1.18.10\\\"} -->\",\"state\":\"1\",\"catid\":\"2\",\"created\":\"2019-02-05 00:11:17\",\"created_by\":\"301\",\"created_by_alias\":\"\",\"modified\":\"2019-02-28 19:47:25\",\"modified_by\":\"301\",\"checked_out\":\"0\",\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2019-02-05 00:11:17\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":209,\"ordering\":\"6\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"2705\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0');/**ABDB**/
/**ABDB**/INSERT INTO `i52lw_ucm_history`  VALUES 
('673', '1', '1', '', '2019-02-28 19:52:09', '301', '54755', 'e1d5f9f1290849bf5e3e1d651a758a16b15b7d96', '{\"id\":\"1\",\"asset_id\":\"63\",\"title\":\"home\",\"alias\":\"home\",\"introtext\":\"<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_HomeGraphic-SharedIdeasCollaboration-mobile.png\\\" alt=\\\"\\\">\\n<h6>&nbsp;<br \\/>&nbsp;<\\/h6>\\n<h3>Uncover possibilities<br \\/> that seem just beyond<br \\/> reach... one good conversation at a time.<\\/h3>\\n<h3><p><span style=\\\"font-size: 42px; line-height: 1.2em;\\\">Uncover possibilities<br \\/> that seem just beyond<br \\/> reach... one good conversation at a time.<\\/span><\\/p><\\/h3>\\n<h2><span style=\\\"font-size: 36px; line-height: 1.1em;\\\">Uncover possibilities that seem just beyond reach... one good conversation at a time.<\\/span><\\/h2>\\n<div><p>Create connection. Use laughter. Imagine change. Make a plan. This is how we shape strong teams and good leaders. I will help you learn how.<\\/p><\\/div>\\n<div><p><span style=\\\"font-size: 22pt; line-height: 22pt;\\\">Create connection. Use laughter. Imagine change. Make a plan. This is how we shape strong teams and good leaders. I will help you learn how.<\\/span><\\/p><\\/div>\\n<h2>EXPERIENCE IS EVERYTHING<\\/h2>\\n<div><div class=\\\"uk-visible@m\\\">I design & deliver tailored, transformative leadership and learning experiences for people, brands and businesses.<br><br>\\nWhether you\\u2019re part of a Fortune 500 company or a lone entrepreneur, I help uncover what matters most, and work closely with you to design the best solution.<\\/div>\\n\\n<div class=\\\"uk-hidden@m\\\"><span style=\\\"font-size: 22px; line-height: 1.25em;\\\">I design & deliver tailored, transformative leadership and learning experiences for people, brands and businesses.<br><br>\\nWhether you\\u2019re part of a Fortune 500 company or a lone entrepreneur, I help uncover what matters most, and work closely with you to design the best solution.<\\/span><\\/div><\\/div>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Spacer.png\\\" alt=\\\"\\\">\\n<h1>&nbsp;<br \\/>&nbsp;<\\/h1>\\n<h2>WHAT I BELIEVE<\\/h2>\\n<div><p><span style=\\\"color: #333333;\\\">The average person will spend 90,000 hours at work over a lifetime. I know, I had to sit down when I read it too. Work and life are not separate, which is why your life\\u2019s work needs to be a priority. We have an opportunity to go beyond daily survival skills and practice new ways to be confident, kind and successful humans in the world. That\\u2019s the work I do.<\\/span><\\/p><\\/div>\\n<h2>Here\\u2019s what it\\u2019s like to work with me:<\\/h2>\\n<div>\\u201cI know firsthand the positive impact Elaine has within organizations and I can always count on her to deliver. She is an expert in her field who I have seen bring out the best in the teams she works with. Elaine is a triple threat; designer, facilitator and leadership subject expert who brings a unique ability to create solutions for organizations.\\u201d\\n<\\/div>\\n<h4>JANEEN SPEER, VP TALENT<br>\\nSHOPIFY<\\/h4>\\n<div><p>\\u201cI have worked with hundreds of people who do what she does, both coaches and facilitators, and Elaine stands above them all. She is excellent at the many ways in which she supports clients and organizations. She is not like the rest, Elaine is in a league of her own.\\u201d<\\/p><\\/div>\\n<h4>SARAH DICKINSON, CO-FOUNDER AND MANAGING DIRECTOR<br>\\nTHNK SCHOOL OF CREATIVE LEADERSHIP<\\/h4>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_HomeQuotesGraphic.jpg\\\" alt=\\\"\\\">\\n<div><p>\\u201cThere I was, minding my own business taking an Executive Leadership Program and in front of the room, blowing my mind, was Elaine. She took us on a journey to shake us up and lead us through establishing a culture for innovative thinking while we laughed our way through design thinking exercises day after day. Mission fulfilled. At the end, I felt like the guy who loved the product so much I bought the company, but in this case I bought a little more of Elaine\'s time for my company.<\\/p>\\n<p>Currently with CAGR of 20% over the last four years, 2,000 employees and $1\\/2 Billion in managed assets, Innisfree is a dynamic, and growing organization. After Elaine\\u2019s first year with Innisfree\'s leadership team, I quickly came to the realization that I have done us a tremendous favor. Elaine has led Innisfree senior management through several iterations to begin the sea change of culture toward a more innovative environment.\\u201d\\n<\\/p><\\/div>\\n<h4>JULIAN MACQUEEN, CHAIRMAN & FOUNDER<br>\\nINNISFREE HOTELS<\\/h4>\\n<h2>Here\\u2019s what it\\u2019s like to work with me:<\\/h2>\\n<div><p>\\u201cThere I was, minding my own business taking an Executive Leadership Program and in front of the room, blowing my mind, was Elaine. She took us on a journey to shake us up and lead us through establishing a culture for innovative thinking while we laughed our way through design thinking exercises day after day. Mission fulfilled. At the end, I felt like the guy who loved the product so much I bought the company, but in this case I bought a little more of Elaine\'s time for my company.<\\/p>\\n<p>Currently with CAGR of 20% over the last four years, 2,000 employees and $1\\/2 Billion in managed assets, Innisfree is a dynamic, and growing organization. After Elaine\\u2019s first year with Innisfree\'s leadership team, I quickly came to the realization that I have done us a tremendous favor. Elaine has led Innisfree senior management through several iterations to begin the sea change of culture toward a more innovative environment.\\u201d\\n<\\/p><\\/div>\\n<h4>JULIAN MACQUEEN, CHAIRMAN & FOUNDER<br>\\nINNISFREE HOTELS<\\/h4>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_HomeTalkingHeadsGraphic2.png\\\" alt=\\\"\\\">\\n<h2>Tailor-made<br>\\nLeadership Experiences<\\/h2>\\n<div>You have the time, the budget and the desire to shape a memorable experience for your people. Your culture is distinct and you want a tailored solution to get to the next level. You\\u2019re seeking a skilled partner who gets you and your people. The good, the bad and the \\u201cyeah we really need to deal with that\\u201d parts of your organization.<\\/div>\\n<p>\\n    <a href=\\\"tailor-made-leadership\\\">Learn More<\\/a>\\n<\\/p>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Home-GroupCircleGraphic2.png\\\" alt=\\\"\\\">\\n<h2>Ready-made<br>\\nLearning Experiences<\\/h2>\\n<div>Your team or conference guests are in need of an inspired approach to evolve the way they think and lead. I promise I\\u2019ve never had anyone fall asleep, and I like a challenge. You\\u2019ll get experienced design and a waiting list of people who want to sign up. This catalogue provides solutions to enliven learning and connection with any group. Yes, even those groups.<\\/div>\\n<p>\\n    <a href=\\\"ready-made-learning\\\">Learn More<\\/a>\\n<\\/p>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Home-HighFiveGraphic3.png\\\" alt=\\\"\\\">\\n<h2>One-to-one<br>\\nExecutive Coaching<\\/h2>\\n<div>You\\u2019ve got big ideas, tricky team dynamics or changes to lead. I\\u2019m skilled, caring, and will challenge that voice inside your head, you know the one. Set time aside to prioritize thoughtful reflection with an experienced advisor. I coach a select group of leaders and entrepreneurs who do the work to get results, and happen to have a good sense of humour, as well.<\\/div>\\n<p>\\n    <a href=\\\"one-to-one-coaching\\\">Learn More<\\/a>\\n<\\/p>\\n<h2>ELAINE IS LOVED BY THESE COMPANIES, AND MORE.<\\/h2>\\n<ul>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-Westjet.png\\\" alt=\\\"\\\">\\n\\n<h3>Westjet Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/www.westjet.com\\/en-ca\\/index\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-Banff-Centre.png\\\" alt=\\\"\\\">\\n\\n<h3>Banff Centre Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/www.banffcentre.ca\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-THNK-Leadership.png\\\" alt=\\\"\\\">\\n\\n<h3>THNK Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/www.thnk.org\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-Lululemon.png\\\" alt=\\\"\\\">\\n\\n<h3>Lululemon Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/shop.lululemon.com\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-MEC.png\\\" alt=\\\"\\\">\\n\\n<h3>MEC Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/www.mec.ca\\/en\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-GoPro.png\\\" alt=\\\"\\\">\\n\\n<h3>Go Pro Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/gopro.com\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n    <\\/ul>\\n\",\"fulltext\":\"<!-- {\\\"name\\\":\\\"Home Page v2\\\",\\\"type\\\":\\\"layout\\\",\\\"children\\\":[{\\\"name\\\":\\\"Hero\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"primary\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"bottom-left\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"dark\\\",\\\"animation\\\":\\\"fade\\\",\\\"padding_remove_bottom\\\":true,\\\"padding_remove_top\\\":true,\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_width\\\":\\\"700\\\",\\\"image_height\\\":\\\"400\\\",\\\"overlap\\\":false,\\\"css\\\":\\\"@media only screen and (min-width: 1250px) {\\\\n.el-section {\\\\n    min-height: 638px;\\\\n}\\\\n\\\\n.uk-grid {\\\\n    min-height: 638px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1249px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 550px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1000px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 350px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"s\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"expand\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"margin_remove_bottom\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"bottom-right\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeGraphic-SharedIdeasCollaboration_1x1Right.png\\\",\\\"image_size\\\":\\\"contain\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"m\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_height\\\":\\\"\\\",\\\"image_parallax_breakpoint\\\":\\\"\\\",\\\"image_parallax_bgx_start\\\":\\\"\\\",\\\"image_parallax_bgy_start\\\":\\\"70\\\",\\\"image_width\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"Image uk-visible@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"-55\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-20\\\",\\\"parallax_x_end\\\":\\\"-20\\\",\\\"parallax_y_end\\\":\\\"-55\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Image uk-hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"15\\\",\\\"class\\\":\\\"uk-hidden@m\\\",\\\"margin_remove_bottom\\\":true,\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-5\\\",\\\"parallax_x_end\\\":\\\"-5\\\",\\\"parallax_y_end\\\":\\\"15\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Top Graphic hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeGraphic-SharedIdeasCollaboration-mobile.png\\\",\\\"margin_remove_top\\\":false,\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden@m\\\",\\\"image_width\\\":\\\"250\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"light\\\",\\\"padding\\\":\\\"none\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  \\\\n  \\\\n  padding-left: 120px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n\\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n  padding-bottom: 20px;\\\\n}\\\\n}\\\\n\\\\n\\\\n.uk-tile-default {\\\\n    background: rgba(255, 255, 255, 0.0);\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"spacer @desktop\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h6\\\",\\\"title_style\\\":\\\"heading-hero\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"&nbsp;<br \\\\\\/>&nbsp;\\\",\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden\\\",\\\"margin_remove_top\\\":true}},{\\\"name\\\":\\\"Headline @L\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Uncover possibilities<br \\\\\\/> that seem just beyond<br \\\\\\/> reach... one good conversation at a time.\\\",\\\"class\\\":\\\"uk-light uk-visible@l hidden@m\\\"}},{\\\"name\\\":\\\"Headline @M\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 42px; line-height: 1.2em;\\\\\\\">Uncover possibilities<br \\\\\\/> that seem just beyond<br \\\\\\/> reach... one good conversation at a time.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@m uk-hidden@l\\\"}},{\\\"name\\\":\\\"Headline @S\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h3\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<span style=\\\\\\\"font-size: 36px; line-height: 1.1em;\\\\\\\">Uncover possibilities that seem just beyond reach... one good conversation at a time.<\\\\\\/span>\\\",\\\"class\\\":\\\"uk-hidden@m uk-light\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true}},{\\\"name\\\":\\\"Text @S hidden@s\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"small\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>Create connection. Use laughter. Imagine change. Make a plan. This is how we shape strong teams and good leaders. I will help you learn how.<\\\\\\/p>\\\",\\\"class\\\":\\\"uk-hidden@l uk-light uk-visible@m\\\",\\\"margin_remove_bottom\\\":false}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 22pt; line-height: 22pt;\\\\\\\">Create connection. Use laughter. Imagine change. Make a plan. This is how we shape strong teams and good leaders. I will help you learn how.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@l\\\"}}]}]}]},{\\\"name\\\":\\\"Intro\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"padding_remove_top\\\":false,\\\"padding_remove_bottom\\\":false,\\\"css\\\":\\\"\\\",\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true,\\\"divider\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"EXPERIENCE IS EVERYTHING\\\",\\\"css\\\":\\\"\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"large\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<div class=\\\\\\\"uk-visible@m\\\\\\\">I design & deliver tailored, transformative leadership and learning experiences for people, brands and businesses.<br><br>\\\\nWhether you\\\\u2019re part of a Fortune 500 company or a lone entrepreneur, I help uncover what matters most, and work closely with you to design the best solution.<\\\\\\/div>\\\\n\\\\n<div class=\\\\\\\"uk-hidden@m\\\\\\\"><span style=\\\\\\\"font-size: 22px; line-height: 1.25em;\\\\\\\">I design & deliver tailored, transformative leadership and learning experiences for people, brands and businesses.<br><br>\\\\nWhether you\\\\u2019re part of a Fortune 500 company or a lone entrepreneur, I help uncover what matters most, and work closely with you to design the best solution.<\\\\\\/span><\\\\\\/div>\\\",\\\"css\\\":\\\"\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-left\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeClassRoomCollaboration3.jpg\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Spacer.png\\\"}},{\\\"name\\\":\\\"spacer @mobile\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h1\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"&nbsp;<br \\\\\\/>&nbsp;\\\",\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden@s\\\",\\\"margin_remove_top\\\":true}}]}]}]},{\\\"name\\\":\\\"What I believe\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"css\\\":\\\".el-section {\\\\n    background-color: #F8925E;\\\\n    \\\\n}\\\\n\\\\n@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 40px; \\\\n  padding-left: 90px;\\\\n  padding-right: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n  padding-right: 30px;\\\\n}\\\\n}\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"WHAT I BELIEVE\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"large\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"color: #333333;\\\\\\\">The average person will spend 90,000 hours at work over a lifetime. I know, I had to sit down when I read it too. Work and life are not separate, which is why your life\\\\u2019s work needs to be a priority. We have an opportunity to go beyond daily survival skills and practice new ways to be confident, kind and successful humans in the world. That\\\\u2019s the work I do.<\\\\\\/span><\\\\\\/p>\\\"}}]}]}]},{\\\"name\\\":\\\"to work with me @desktop\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"muted\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"css\\\":\\\"\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"margin_remove_bottom\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  padding-top: 50px;\\\\n   \\\\n  padding-left: 115px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  padding-top: 30px;\\\\n   \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"heading-primary\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Here\\\\u2019s what it\\\\u2019s like to work with me:\\\"}}]}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"divider\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  \\\\n  padding-bottom: 60px; \\\\n  padding-left: 115px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  \\\\n  padding-bottom: 30px; \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"\\\\u201cI know firsthand the positive impact Elaine has within organizations and I can always count on her to deliver. She is an expert in her field who I have seen bring out the best in the teams she works with. Elaine is a triple threat; designer, facilitator and leadership subject expert who brings a unique ability to create solutions for organizations.\\\\u201d\\\\n\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h4\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"JANEEN SPEER, VP TALENT<br>\\\\nSHOPIFY\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"divider\\\",\\\"props\\\":{\\\"divider_element\\\":\\\"div\\\",\\\"divider_style\\\":\\\"small\\\",\\\"divider_align\\\":\\\"\\\",\\\"divider_align_breakpoint\\\":\\\"\\\",\\\"divider_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>\\\\u201cI have worked with hundreds of people who do what she does, both coaches and facilitators, and Elaine stands above them all. She is excellent at the many ways in which she supports clients and organizations. She is not like the rest, Elaine is in a league of her own.\\\\u201d<\\\\\\/p>\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h4\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"SARAH DICKINSON, CO-FOUNDER AND MANAGING DIRECTOR<br>\\\\nTHNK SCHOOL OF CREATIVE LEADERSHIP\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"divider\\\",\\\"props\\\":{\\\"divider_element\\\":\\\"div\\\",\\\"divider_style\\\":\\\"small\\\",\\\"divider_align\\\":\\\"\\\",\\\"divider_align_breakpoint\\\":\\\"\\\",\\\"divider_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 45px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\\n\\\\n\\\\\\/* Experimental *\\\\\\/\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"right\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeQuotesGraphic.jpg\\\",\\\"image_height\\\":\\\"50\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>\\\\u201cThere I was, minding my own business taking an Executive Leadership Program and in front of the room, blowing my mind, was Elaine. She took us on a journey to shake us up and lead us through establishing a culture for innovative thinking while we laughed our way through design thinking exercises day after day. Mission fulfilled. At the end, I felt like the guy who loved the product so much I bought the company, but in this case I bought a little more of Elaine\'s time for my company.<\\\\\\/p>\\\\n<p>Currently with CAGR of 20% over the last four years, 2,000 employees and $1\\\\\\/2 Billion in managed assets, Innisfree is a dynamic, and growing organization. After Elaine\\\\u2019s first year with Innisfree\'s leadership team, I quickly came to the realization that I have done us a tremendous favor. Elaine has led Innisfree senior management through several iterations to begin the sea change of culture toward a more innovative environment.\\\\u201d\\\\n<\\\\\\/p>\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h4\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"JULIAN MACQUEEN, CHAIRMAN & FOUNDER<br>\\\\nINNISFREE HOTELS\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"divider\\\",\\\"props\\\":{\\\"divider_element\\\":\\\"div\\\",\\\"divider_style\\\":\\\"small\\\",\\\"divider_align\\\":\\\"\\\",\\\"divider_align_breakpoint\\\":\\\"\\\",\\\"divider_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"}}]}]}]},{\\\"name\\\":\\\"to work with me @mobile\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"muted\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"css\\\":\\\"\\\",\\\"class\\\":\\\"uk-hidden@m\\\",\\\"image_effect\\\":\\\"\\\",\\\"padding_remove_top\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"divider\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 115px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Here\\\\u2019s what it\\\\u2019s like to work with me:\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>\\\\u201cThere I was, minding my own business taking an Executive Leadership Program and in front of the room, blowing my mind, was Elaine. She took us on a journey to shake us up and lead us through establishing a culture for innovative thinking while we laughed our way through design thinking exercises day after day. Mission fulfilled. At the end, I felt like the guy who loved the product so much I bought the company, but in this case I bought a little more of Elaine\'s time for my company.<\\\\\\/p>\\\\n<p>Currently with CAGR of 20% over the last four years, 2,000 employees and $1\\\\\\/2 Billion in managed assets, Innisfree is a dynamic, and growing organization. After Elaine\\\\u2019s first year with Innisfree\'s leadership team, I quickly came to the realization that I have done us a tremendous favor. Elaine has led Innisfree senior management through several iterations to begin the sea change of culture toward a more innovative environment.\\\\u201d\\\\n<\\\\\\/p>\\\",\\\"css\\\":\\\"\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h4\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"JULIAN MACQUEEN, CHAIRMAN & FOUNDER<br>\\\\nINNISFREE HOTELS\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"divider\\\",\\\"props\\\":{\\\"divider_element\\\":\\\"div\\\",\\\"divider_style\\\":\\\"small\\\",\\\"divider_align\\\":\\\"\\\",\\\"divider_align_breakpoint\\\":\\\"\\\",\\\"divider_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"}}]}]}]},{\\\"name\\\":\\\"Services - Tailor Made\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"animation_delay\\\":true,\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"divider\\\":false,\\\"margin_remove_bottom\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\".el-section {\\\\n    background-color: #9CC788;\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"slide-left-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeTalkingHeadsGraphic2.png\\\",\\\"image_height\\\":\\\"505\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"xsmall\\\",\\\"css\\\":\\\"@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n\\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n  padding-bottom: 40px;\\\\n  padding-top: 10px;\\\\n        \\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"heading-primary\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Tailor-made<br>\\\\nLeadership Experiences\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"You have the time, the budget and the desire to shape a memorable experience for your people. Your culture is distinct and you want a tailored solution to get to the next level. You\\\\u2019re seeking a skilled partner who gets you and your people. The good, the bad and the \\\\u201cyeah we really need to deal with that\\\\u201d parts of your organization.\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button\\\",\\\"props\\\":{\\\"gutter\\\":\\\"small\\\",\\\"margin\\\":\\\"default\\\",\\\"button_size\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button_item\\\",\\\"props\\\":{\\\"button_style\\\":\\\"default\\\",\\\"icon_align\\\":\\\"left\\\",\\\"link_target\\\":\\\"\\\",\\\"content\\\":\\\"Learn More\\\",\\\"link\\\":\\\"tailor-made-leadership\\\"}}]}]}]}]},{\\\"name\\\":\\\"Services - Ready-Made\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"animation_delay\\\":true,\\\"css\\\":\\\"@media (min-width: 960px){\\\\n.uk-tile {\\\\n    padding-left: 70px;\\\\n    padding-right: 40px;\\\\n    padding-top: 65px;\\\\n    padding-bottom: 65px;\\\\n}\\\\n}\\\",\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"divider\\\":false,\\\"margin_remove_bottom\\\":true,\\\"order_last\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\".el-section {\\\\n    background-color: #F4EBC6;\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"slide-right-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Home-GroupCircleGraphic2.png\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"xsmall\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"heading-primary\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Ready-made<br>\\\\nLearning Experiences\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Your team or conference guests are in need of an inspired approach to evolve the way they think and lead. I promise I\\\\u2019ve never had anyone fall asleep, and I like a challenge. You\\\\u2019ll get experienced design and a waiting list of people who want to sign up. This catalogue provides solutions to enliven learning and connection with any group. Yes, even those groups.\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button\\\",\\\"props\\\":{\\\"gutter\\\":\\\"small\\\",\\\"margin\\\":\\\"default\\\",\\\"button_size\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button_item\\\",\\\"props\\\":{\\\"button_style\\\":\\\"default\\\",\\\"icon_align\\\":\\\"left\\\",\\\"link_target\\\":\\\"\\\",\\\"content\\\":\\\"Learn More\\\",\\\"link\\\":\\\"ready-made-learning\\\"}}]}]}]}]},{\\\"name\\\":\\\"Services - One-to-one\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"animation_delay\\\":true,\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"divider\\\":false,\\\"margin_remove_bottom\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"secondary\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"slide-left-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Home-HighFiveGraphic3.png\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"xsmall\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"heading-primary\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"One-to-one<br>\\\\nExecutive Coaching\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"You\\\\u2019ve got big ideas, tricky team dynamics or changes to lead. I\\\\u2019m skilled, caring, and will challenge that voice inside your head, you know the one. Set time aside to prioritize thoughtful reflection with an experienced advisor. I coach a select group of leaders and entrepreneurs who do the work to get results, and happen to have a good sense of humour, as well.\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button\\\",\\\"props\\\":{\\\"gutter\\\":\\\"small\\\",\\\"margin\\\":\\\"default\\\",\\\"button_size\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button_item\\\",\\\"props\\\":{\\\"button_style\\\":\\\"default\\\",\\\"icon_align\\\":\\\"left\\\",\\\"link_target\\\":\\\"\\\",\\\"content\\\":\\\"Learn More\\\",\\\"link\\\":\\\"one-to-one-coaching\\\"}}]}]}]}]},{\\\"name\\\":\\\"Image Parallax\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"default\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"percent\\\",\\\"padding\\\":\\\"\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeElaineTeachesGroupBW.jpg\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"fixed\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_parallax_breakpoint\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\"}}]}]},{\\\"name\\\":\\\"Clients - Partners\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"slide-top-small\\\",\\\"animation_delay\\\":true,\\\"image_effect\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 90px;\\\\n  padding-right: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    el-section {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n  padding-right: 30px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"large\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"ELAINE IS LOVED BY THESE COMPANIES, AND MORE.\\\",\\\"margin_remove_top\\\":true}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid\\\",\\\"props\\\":{\\\"show_title\\\":false,\\\"show_meta\\\":false,\\\"show_content\\\":false,\\\"show_image\\\":true,\\\"show_link\\\":true,\\\"grid_default\\\":\\\"2\\\",\\\"grid_medium\\\":\\\"3\\\",\\\"filter_style\\\":\\\"tab\\\",\\\"filter_all\\\":true,\\\"filter_position\\\":\\\"top\\\",\\\"filter_align\\\":\\\"left\\\",\\\"filter_grid_width\\\":\\\"auto\\\",\\\"filter_breakpoint\\\":\\\"m\\\",\\\"title_element\\\":\\\"h3\\\",\\\"meta_style\\\":\\\"meta\\\",\\\"meta_align\\\":\\\"bottom\\\",\\\"icon_ratio\\\":4,\\\"image_align\\\":\\\"between\\\",\\\"image_grid_width\\\":\\\"1-2\\\",\\\"image_breakpoint\\\":\\\"m\\\",\\\"link_text\\\":\\\"Read more\\\",\\\"link_style\\\":\\\"panel\\\",\\\"margin\\\":\\\"default\\\",\\\"item_animation\\\":\\\"fade\\\",\\\"gutter\\\":\\\"\\\",\\\"grid_small\\\":\\\"\\\",\\\"grid_large\\\":\\\"6\\\",\\\"grid_xlarge\\\":\\\"6\\\",\\\"filter_margin\\\":\\\"\\\",\\\"filter_gutter\\\":\\\"\\\",\\\"title_display\\\":\\\"\\\",\\\"content_display\\\":\\\"\\\",\\\"panel_style\\\":\\\"\\\",\\\"panel_size\\\":\\\"\\\",\\\"item_maxwidth\\\":\\\"\\\",\\\"title_style\\\":\\\"\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"meta_color\\\":\\\"\\\",\\\"meta_margin\\\":\\\"\\\",\\\"content_style\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"icon_color\\\":\\\"\\\",\\\"image_gutter\\\":\\\"\\\",\\\"link_size\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"link_target\\\":true,\\\"grid_masonry\\\":false,\\\"grid_parallax\\\":\\\"0\\\",\\\"image_height\\\":\\\"65\\\",\\\"divider\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"Westjet Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-Westjet.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.westjet.com\\\\\\/en-ca\\\\\\/index\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"Banff Centre Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-Banff-Centre.png\\\",\\\"image_alt\\\":\\\"\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.banffcentre.ca\\\\\\/\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"THNK Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-THNK-Leadership.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.thnk.org\\\\\\/\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"Lululemon Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-Lululemon.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/shop.lululemon.com\\\\\\/\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"MEC Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-MEC.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.mec.ca\\\\\\/en\\\\\\/\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"Go Pro Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-GoPro.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/gopro.com\\\\\\/\\\"}}]}]}]}]}],\\\"props\\\":[],\\\"version\\\":\\\"1.18.10\\\"} -->\",\"state\":\"1\",\"catid\":\"2\",\"created\":\"2019-02-05 00:11:17\",\"created_by\":\"301\",\"created_by_alias\":\"\",\"modified\":\"2019-02-28 19:52:09\",\"modified_by\":\"301\",\"checked_out\":\"0\",\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2019-02-05 00:11:17\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":210,\"ordering\":\"6\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"2723\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('674', '1', '1', '', '2019-02-28 19:53:11', '301', '54578', '0569e642bb215dcaecb0266bebdc8aecde7c4ec8', '{\"id\":\"1\",\"asset_id\":\"63\",\"title\":\"home\",\"alias\":\"home\",\"introtext\":\"<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_HomeGraphic-SharedIdeasCollaboration-mobile.png\\\" alt=\\\"\\\">\\n<h6>&nbsp;<br \\/>&nbsp;<\\/h6>\\n<h3>Uncover possibilities<br \\/> that seem just beyond<br \\/> reach... one good conversation at a time.<\\/h3>\\n<h3><p><span style=\\\"font-size: 42px; line-height: 1.2em;\\\">Uncover possibilities<br \\/> that seem just beyond<br \\/> reach... one good conversation at a time.<\\/span><\\/p><\\/h3>\\n<h2><span style=\\\"font-size: 36px; line-height: 1.1em;\\\">Uncover possibilities that seem just beyond reach... one good conversation at a time.<\\/span><\\/h2>\\n<div><p>Create connection. Use laughter. Imagine change. Make a plan. This is how we shape strong teams and good leaders. I will help you learn how.<\\/p><\\/div>\\n<div><p><span style=\\\"font-size: 22pt; line-height: 22pt;\\\">Create connection. Use laughter. Imagine change. Make a plan. This is how we shape strong teams and good leaders. I will help you learn how.<\\/span><\\/p><\\/div>\\n<h2>EXPERIENCE IS EVERYTHING<\\/h2>\\n<div><div class=\\\"uk-visible@m\\\">I design & deliver tailored, transformative leadership and learning experiences for people, brands and businesses.<br><br>\\nWhether you\\u2019re part of a Fortune 500 company or a lone entrepreneur, I help uncover what matters most, and work closely with you to design the best solution.<\\/div>\\n\\n<div class=\\\"uk-hidden@m\\\"><span style=\\\"font-size: 22px; line-height: 1.25em;\\\">I design & deliver tailored, transformative leadership and learning experiences for people, brands and businesses.<br><br>\\nWhether you\\u2019re part of a Fortune 500 company or a lone entrepreneur, I help uncover what matters most, and work closely with you to design the best solution.<\\/span><\\/div><\\/div>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Spacer.png\\\" alt=\\\"\\\">\\n<h1>&nbsp;<br \\/>&nbsp;<\\/h1>\\n<h2>WHAT I BELIEVE<\\/h2>\\n<div><p><span style=\\\"color: #333333;\\\">The average person will spend 90,000 hours at work over a lifetime. I know, I had to sit down when I read it too. Work and life are not separate, which is why your life\\u2019s work needs to be a priority. We have an opportunity to go beyond daily survival skills and practice new ways to be confident, kind and successful humans in the world. That\\u2019s the work I do.<\\/span><\\/p><\\/div>\\n<h2>Here\\u2019s what it\\u2019s like to work with me:<\\/h2>\\n<div>\\u201cI know firsthand the positive impact Elaine has within organizations and I can always count on her to deliver. She is an expert in her field who I have seen bring out the best in the teams she works with. Elaine is a triple threat; designer, facilitator and leadership subject expert who brings a unique ability to create solutions for organizations.\\u201d\\n<\\/div>\\n<h4>JANEEN SPEER, VP TALENT<br>\\nSHOPIFY<\\/h4>\\n<div><p>\\u201cI have worked with hundreds of people who do what she does, both coaches and facilitators, and Elaine stands above them all. She is excellent at the many ways in which she supports clients and organizations. She is not like the rest, Elaine is in a league of her own.\\u201d<\\/p><\\/div>\\n<h4>SARAH DICKINSON, CO-FOUNDER AND MANAGING DIRECTOR<br>\\nTHNK SCHOOL OF CREATIVE LEADERSHIP<\\/h4>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_HomeQuotesGraphic.jpg\\\" alt=\\\"\\\">\\n<div><p>\\u201cThere I was, minding my own business taking an Executive Leadership Program and in front of the room, blowing my mind, was Elaine. She took us on a journey to shake us up and lead us through establishing a culture for innovative thinking while we laughed our way through design thinking exercises day after day. Mission fulfilled. At the end, I felt like the guy who loved the product so much I bought the company, but in this case I bought a little more of Elaine\'s time for my company.<\\/p>\\n<p>Currently with CAGR of 20% over the last four years, 2,000 employees and $1\\/2 Billion in managed assets, Innisfree is a dynamic, and growing organization. After Elaine\\u2019s first year with Innisfree\'s leadership team, I quickly came to the realization that I have done us a tremendous favor. Elaine has led Innisfree senior management through several iterations to begin the sea change of culture toward a more innovative environment.\\u201d\\n<\\/p><\\/div>\\n<h4>JULIAN MACQUEEN, CHAIRMAN & FOUNDER<br>\\nINNISFREE HOTELS<\\/h4>\\n<h2>Here\\u2019s what it\\u2019s like to work with me:<\\/h2>\\n<div><p>\\u201cThere I was, minding my own business taking an Executive Leadership Program and in front of the room, blowing my mind, was Elaine. She took us on a journey to shake us up and lead us through establishing a culture for innovative thinking while we laughed our way through design thinking exercises day after day. Mission fulfilled. At the end, I felt like the guy who loved the product so much I bought the company, but in this case I bought a little more of Elaine\'s time for my company.<\\/p>\\n<p>Currently with CAGR of 20% over the last four years, 2,000 employees and $1\\/2 Billion in managed assets, Innisfree is a dynamic, and growing organization. After Elaine\\u2019s first year with Innisfree\'s leadership team, I quickly came to the realization that I have done us a tremendous favor. Elaine has led Innisfree senior management through several iterations to begin the sea change of culture toward a more innovative environment.\\u201d\\n<\\/p><\\/div>\\n<h4>JULIAN MACQUEEN, CHAIRMAN & FOUNDER<br>\\nINNISFREE HOTELS<\\/h4>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_HomeTalkingHeadsGraphic2.png\\\" alt=\\\"\\\">\\n<h2>Tailor-made<br>\\nLeadership Experiences<\\/h2>\\n<div>You have the time, the budget and the desire to shape a memorable experience for your people. Your culture is distinct and you want a tailored solution to get to the next level. You\\u2019re seeking a skilled partner who gets you and your people. The good, the bad and the \\u201cyeah we really need to deal with that\\u201d parts of your organization.<\\/div>\\n<p>\\n    <a href=\\\"tailor-made-leadership\\\">Learn More<\\/a>\\n<\\/p>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Home-GroupCircleGraphic2.png\\\" alt=\\\"\\\">\\n<h2>Ready-made<br>\\nLearning Experiences<\\/h2>\\n<div>Your team or conference guests are in need of an inspired approach to evolve the way they think and lead. I promise I\\u2019ve never had anyone fall asleep, and I like a challenge. You\\u2019ll get experienced design and a waiting list of people who want to sign up. This catalogue provides solutions to enliven learning and connection with any group. Yes, even those groups.<\\/div>\\n<p>\\n    <a href=\\\"ready-made-learning\\\">Learn More<\\/a>\\n<\\/p>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Home-HighFiveGraphic3.png\\\" alt=\\\"\\\">\\n<h2>One-to-one<br>\\nExecutive Coaching<\\/h2>\\n<div>You\\u2019ve got big ideas, tricky team dynamics or changes to lead. I\\u2019m skilled, caring, and will challenge that voice inside your head, you know the one. Set time aside to prioritize thoughtful reflection with an experienced advisor. I coach a select group of leaders and entrepreneurs who do the work to get results, and happen to have a good sense of humour, as well.<\\/div>\\n<p>\\n    <a href=\\\"one-to-one-coaching\\\">Learn More<\\/a>\\n<\\/p>\\n<h2>ELAINE IS LOVED BY THESE COMPANIES, AND MORE.<\\/h2>\\n<ul>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-Westjet.png\\\" alt=\\\"\\\">\\n\\n<h3>Westjet Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/www.westjet.com\\/en-ca\\/index\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-Banff-Centre.png\\\" alt=\\\"\\\">\\n\\n<h3>Banff Centre Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/www.banffcentre.ca\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-THNK-Leadership.png\\\" alt=\\\"\\\">\\n\\n<h3>THNK Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/www.thnk.org\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-Lululemon.png\\\" alt=\\\"\\\">\\n\\n<h3>Lululemon Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/shop.lululemon.com\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-MEC.png\\\" alt=\\\"\\\">\\n\\n<h3>MEC Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/www.mec.ca\\/en\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-GoPro.png\\\" alt=\\\"\\\">\\n\\n<h3>Go Pro Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/gopro.com\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n    <\\/ul>\\n\",\"fulltext\":\"<!-- {\\\"name\\\":\\\"Home Page v2\\\",\\\"type\\\":\\\"layout\\\",\\\"children\\\":[{\\\"name\\\":\\\"Hero\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"primary\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"bottom-left\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"dark\\\",\\\"animation\\\":\\\"fade\\\",\\\"padding_remove_bottom\\\":true,\\\"padding_remove_top\\\":true,\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_width\\\":\\\"700\\\",\\\"image_height\\\":\\\"400\\\",\\\"overlap\\\":false,\\\"css\\\":\\\"@media only screen and (min-width: 1250px) {\\\\n.el-section {\\\\n    min-height: 638px;\\\\n}\\\\n\\\\n.uk-grid {\\\\n    min-height: 638px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1249px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 550px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1000px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 350px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"s\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"expand\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"margin_remove_bottom\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"bottom-right\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeGraphic-SharedIdeasCollaboration_1x1Right.png\\\",\\\"image_size\\\":\\\"contain\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"m\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_height\\\":\\\"\\\",\\\"image_parallax_breakpoint\\\":\\\"\\\",\\\"image_parallax_bgx_start\\\":\\\"\\\",\\\"image_parallax_bgy_start\\\":\\\"70\\\",\\\"image_width\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"Image uk-visible@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"-55\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-20\\\",\\\"parallax_x_end\\\":\\\"-20\\\",\\\"parallax_y_end\\\":\\\"-55\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Image uk-hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"15\\\",\\\"class\\\":\\\"uk-hidden@m\\\",\\\"margin_remove_bottom\\\":true,\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-5\\\",\\\"parallax_x_end\\\":\\\"-5\\\",\\\"parallax_y_end\\\":\\\"15\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Top Graphic hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeGraphic-SharedIdeasCollaboration-mobile.png\\\",\\\"margin_remove_top\\\":false,\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden@m\\\",\\\"image_width\\\":\\\"250\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"light\\\",\\\"padding\\\":\\\"none\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  \\\\n  \\\\n  padding-left: 120px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n\\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n  padding-bottom: 20px;\\\\n}\\\\n}\\\\n\\\\n\\\\n.uk-tile-default {\\\\n    background: rgba(255, 255, 255, 0.0);\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"spacer @desktop\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h6\\\",\\\"title_style\\\":\\\"heading-hero\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"&nbsp;<br \\\\\\/>&nbsp;\\\",\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden\\\",\\\"margin_remove_top\\\":true}},{\\\"name\\\":\\\"Headline @L\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Uncover possibilities<br \\\\\\/> that seem just beyond<br \\\\\\/> reach... one good conversation at a time.\\\",\\\"class\\\":\\\"uk-light uk-visible@l hidden@m\\\"}},{\\\"name\\\":\\\"Headline @M\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 42px; line-height: 1.2em;\\\\\\\">Uncover possibilities<br \\\\\\/> that seem just beyond<br \\\\\\/> reach... one good conversation at a time.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@m uk-hidden@l\\\"}},{\\\"name\\\":\\\"Headline @S\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h3\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<span style=\\\\\\\"font-size: 36px; line-height: 1.1em;\\\\\\\">Uncover possibilities that seem just beyond reach... one good conversation at a time.<\\\\\\/span>\\\",\\\"class\\\":\\\"uk-hidden@m uk-light\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true}},{\\\"name\\\":\\\"Text @S hidden@s\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"small\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>Create connection. Use laughter. Imagine change. Make a plan. This is how we shape strong teams and good leaders. I will help you learn how.<\\\\\\/p>\\\",\\\"class\\\":\\\"uk-hidden@l uk-light uk-visible@m\\\",\\\"margin_remove_bottom\\\":false}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 22pt; line-height: 22pt;\\\\\\\">Create connection. Use laughter. Imagine change. Make a plan. This is how we shape strong teams and good leaders. I will help you learn how.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@l\\\"}}]}]}]},{\\\"name\\\":\\\"Intro\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"padding_remove_top\\\":false,\\\"padding_remove_bottom\\\":false,\\\"css\\\":\\\"\\\",\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true,\\\"divider\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"EXPERIENCE IS EVERYTHING\\\",\\\"css\\\":\\\"\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"large\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<div class=\\\\\\\"uk-visible@m\\\\\\\">I design & deliver tailored, transformative leadership and learning experiences for people, brands and businesses.<br><br>\\\\nWhether you\\\\u2019re part of a Fortune 500 company or a lone entrepreneur, I help uncover what matters most, and work closely with you to design the best solution.<\\\\\\/div>\\\\n\\\\n<div class=\\\\\\\"uk-hidden@m\\\\\\\"><span style=\\\\\\\"font-size: 22px; line-height: 1.25em;\\\\\\\">I design & deliver tailored, transformative leadership and learning experiences for people, brands and businesses.<br><br>\\\\nWhether you\\\\u2019re part of a Fortune 500 company or a lone entrepreneur, I help uncover what matters most, and work closely with you to design the best solution.<\\\\\\/span><\\\\\\/div>\\\",\\\"css\\\":\\\"\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-left\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeClassRoomCollaboration3.jpg\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Spacer.png\\\"}},{\\\"name\\\":\\\"spacer @mobile\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h1\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"&nbsp;<br \\\\\\/>&nbsp;\\\",\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden@s\\\",\\\"margin_remove_top\\\":true}}]}]}]},{\\\"name\\\":\\\"What I believe\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"css\\\":\\\".el-section {\\\\n    background-color: #F8925E;\\\\n    \\\\n}\\\\n\\\\n@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 40px; \\\\n  padding-left: 90px;\\\\n  padding-right: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n  padding-right: 30px;\\\\n}\\\\n}\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"WHAT I BELIEVE\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"large\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"color: #333333;\\\\\\\">The average person will spend 90,000 hours at work over a lifetime. I know, I had to sit down when I read it too. Work and life are not separate, which is why your life\\\\u2019s work needs to be a priority. We have an opportunity to go beyond daily survival skills and practice new ways to be confident, kind and successful humans in the world. That\\\\u2019s the work I do.<\\\\\\/span><\\\\\\/p>\\\"}}]}]}]},{\\\"name\\\":\\\"to work with me @desktop\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"muted\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"css\\\":\\\"\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"margin_remove_bottom\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  padding-top: 50px;\\\\n   \\\\n  padding-left: 115px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  padding-top: 30px;\\\\n   \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"heading-primary\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Here\\\\u2019s what it\\\\u2019s like to work with me:\\\"}}]}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"divider\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  \\\\n  padding-bottom: 60px; \\\\n  padding-left: 115px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  \\\\n  padding-bottom: 30px; \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"\\\\u201cI know firsthand the positive impact Elaine has within organizations and I can always count on her to deliver. She is an expert in her field who I have seen bring out the best in the teams she works with. Elaine is a triple threat; designer, facilitator and leadership subject expert who brings a unique ability to create solutions for organizations.\\\\u201d\\\\n\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h4\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"JANEEN SPEER, VP TALENT<br>\\\\nSHOPIFY\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"divider\\\",\\\"props\\\":{\\\"divider_element\\\":\\\"div\\\",\\\"divider_style\\\":\\\"small\\\",\\\"divider_align\\\":\\\"\\\",\\\"divider_align_breakpoint\\\":\\\"\\\",\\\"divider_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>\\\\u201cI have worked with hundreds of people who do what she does, both coaches and facilitators, and Elaine stands above them all. She is excellent at the many ways in which she supports clients and organizations. She is not like the rest, Elaine is in a league of her own.\\\\u201d<\\\\\\/p>\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h4\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"SARAH DICKINSON, CO-FOUNDER AND MANAGING DIRECTOR<br>\\\\nTHNK SCHOOL OF CREATIVE LEADERSHIP\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"divider\\\",\\\"props\\\":{\\\"divider_element\\\":\\\"div\\\",\\\"divider_style\\\":\\\"small\\\",\\\"divider_align\\\":\\\"\\\",\\\"divider_align_breakpoint\\\":\\\"\\\",\\\"divider_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 45px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\\n\\\\n\\\\\\/* Experimental *\\\\\\/\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"right\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeQuotesGraphic.jpg\\\",\\\"image_height\\\":\\\"50\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>\\\\u201cThere I was, minding my own business taking an Executive Leadership Program and in front of the room, blowing my mind, was Elaine. She took us on a journey to shake us up and lead us through establishing a culture for innovative thinking while we laughed our way through design thinking exercises day after day. Mission fulfilled. At the end, I felt like the guy who loved the product so much I bought the company, but in this case I bought a little more of Elaine\'s time for my company.<\\\\\\/p>\\\\n<p>Currently with CAGR of 20% over the last four years, 2,000 employees and $1\\\\\\/2 Billion in managed assets, Innisfree is a dynamic, and growing organization. After Elaine\\\\u2019s first year with Innisfree\'s leadership team, I quickly came to the realization that I have done us a tremendous favor. Elaine has led Innisfree senior management through several iterations to begin the sea change of culture toward a more innovative environment.\\\\u201d\\\\n<\\\\\\/p>\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h4\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"JULIAN MACQUEEN, CHAIRMAN & FOUNDER<br>\\\\nINNISFREE HOTELS\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"divider\\\",\\\"props\\\":{\\\"divider_element\\\":\\\"div\\\",\\\"divider_style\\\":\\\"small\\\",\\\"divider_align\\\":\\\"\\\",\\\"divider_align_breakpoint\\\":\\\"\\\",\\\"divider_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"}}]}]}]},{\\\"name\\\":\\\"to work with me @mobile\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"muted\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"css\\\":\\\"\\\",\\\"class\\\":\\\"uk-hidden@m\\\",\\\"image_effect\\\":\\\"\\\",\\\"padding_remove_top\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"divider\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 115px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Here\\\\u2019s what it\\\\u2019s like to work with me:\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>\\\\u201cThere I was, minding my own business taking an Executive Leadership Program and in front of the room, blowing my mind, was Elaine. She took us on a journey to shake us up and lead us through establishing a culture for innovative thinking while we laughed our way through design thinking exercises day after day. Mission fulfilled. At the end, I felt like the guy who loved the product so much I bought the company, but in this case I bought a little more of Elaine\'s time for my company.<\\\\\\/p>\\\\n<p>Currently with CAGR of 20% over the last four years, 2,000 employees and $1\\\\\\/2 Billion in managed assets, Innisfree is a dynamic, and growing organization. After Elaine\\\\u2019s first year with Innisfree\'s leadership team, I quickly came to the realization that I have done us a tremendous favor. Elaine has led Innisfree senior management through several iterations to begin the sea change of culture toward a more innovative environment.\\\\u201d\\\\n<\\\\\\/p>\\\",\\\"css\\\":\\\"\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h4\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"JULIAN MACQUEEN, CHAIRMAN & FOUNDER<br>\\\\nINNISFREE HOTELS\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"divider\\\",\\\"props\\\":{\\\"divider_element\\\":\\\"div\\\",\\\"divider_style\\\":\\\"small\\\",\\\"divider_align\\\":\\\"\\\",\\\"divider_align_breakpoint\\\":\\\"\\\",\\\"divider_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"}}]}]}]},{\\\"name\\\":\\\"Services - Tailor Made\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"animation_delay\\\":true,\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"divider\\\":false,\\\"margin_remove_bottom\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\".el-section {\\\\n    background-color: #9CC788;\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"slide-left-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeTalkingHeadsGraphic2.png\\\",\\\"image_height\\\":\\\"505\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"xsmall\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"heading-primary\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Tailor-made<br>\\\\nLeadership Experiences\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"You have the time, the budget and the desire to shape a memorable experience for your people. Your culture is distinct and you want a tailored solution to get to the next level. You\\\\u2019re seeking a skilled partner who gets you and your people. The good, the bad and the \\\\u201cyeah we really need to deal with that\\\\u201d parts of your organization.\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button\\\",\\\"props\\\":{\\\"gutter\\\":\\\"small\\\",\\\"margin\\\":\\\"default\\\",\\\"button_size\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button_item\\\",\\\"props\\\":{\\\"button_style\\\":\\\"default\\\",\\\"icon_align\\\":\\\"left\\\",\\\"link_target\\\":\\\"\\\",\\\"content\\\":\\\"Learn More\\\",\\\"link\\\":\\\"tailor-made-leadership\\\"}}]}]}]}]},{\\\"name\\\":\\\"Services - Ready-Made\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"animation_delay\\\":true,\\\"css\\\":\\\"@media (min-width: 960px){\\\\n.uk-tile {\\\\n    padding-left: 70px;\\\\n    padding-right: 40px;\\\\n    padding-top: 65px;\\\\n    padding-bottom: 65px;\\\\n}\\\\n}\\\",\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"divider\\\":false,\\\"margin_remove_bottom\\\":true,\\\"order_last\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\".el-section {\\\\n    background-color: #F4EBC6;\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"slide-right-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Home-GroupCircleGraphic2.png\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"xsmall\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"heading-primary\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Ready-made<br>\\\\nLearning Experiences\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Your team or conference guests are in need of an inspired approach to evolve the way they think and lead. I promise I\\\\u2019ve never had anyone fall asleep, and I like a challenge. You\\\\u2019ll get experienced design and a waiting list of people who want to sign up. This catalogue provides solutions to enliven learning and connection with any group. Yes, even those groups.\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button\\\",\\\"props\\\":{\\\"gutter\\\":\\\"small\\\",\\\"margin\\\":\\\"default\\\",\\\"button_size\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button_item\\\",\\\"props\\\":{\\\"button_style\\\":\\\"default\\\",\\\"icon_align\\\":\\\"left\\\",\\\"link_target\\\":\\\"\\\",\\\"content\\\":\\\"Learn More\\\",\\\"link\\\":\\\"ready-made-learning\\\"}}]}]}]}]},{\\\"name\\\":\\\"Services - One-to-one\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"animation_delay\\\":true,\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"divider\\\":false,\\\"margin_remove_bottom\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"secondary\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"slide-left-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Home-HighFiveGraphic3.png\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"xsmall\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"heading-primary\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"One-to-one<br>\\\\nExecutive Coaching\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"You\\\\u2019ve got big ideas, tricky team dynamics or changes to lead. I\\\\u2019m skilled, caring, and will challenge that voice inside your head, you know the one. Set time aside to prioritize thoughtful reflection with an experienced advisor. I coach a select group of leaders and entrepreneurs who do the work to get results, and happen to have a good sense of humour, as well.\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button\\\",\\\"props\\\":{\\\"gutter\\\":\\\"small\\\",\\\"margin\\\":\\\"default\\\",\\\"button_size\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button_item\\\",\\\"props\\\":{\\\"button_style\\\":\\\"default\\\",\\\"icon_align\\\":\\\"left\\\",\\\"link_target\\\":\\\"\\\",\\\"content\\\":\\\"Learn More\\\",\\\"link\\\":\\\"one-to-one-coaching\\\"}}]}]}]}]},{\\\"name\\\":\\\"Image Parallax\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"default\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"percent\\\",\\\"padding\\\":\\\"\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeElaineTeachesGroupBW.jpg\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"fixed\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_parallax_breakpoint\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\"}}]}]},{\\\"name\\\":\\\"Clients - Partners\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"slide-top-small\\\",\\\"animation_delay\\\":true,\\\"image_effect\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 90px;\\\\n  padding-right: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    el-section {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n  padding-right: 30px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"large\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"ELAINE IS LOVED BY THESE COMPANIES, AND MORE.\\\",\\\"margin_remove_top\\\":true}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid\\\",\\\"props\\\":{\\\"show_title\\\":false,\\\"show_meta\\\":false,\\\"show_content\\\":false,\\\"show_image\\\":true,\\\"show_link\\\":true,\\\"grid_default\\\":\\\"2\\\",\\\"grid_medium\\\":\\\"3\\\",\\\"filter_style\\\":\\\"tab\\\",\\\"filter_all\\\":true,\\\"filter_position\\\":\\\"top\\\",\\\"filter_align\\\":\\\"left\\\",\\\"filter_grid_width\\\":\\\"auto\\\",\\\"filter_breakpoint\\\":\\\"m\\\",\\\"title_element\\\":\\\"h3\\\",\\\"meta_style\\\":\\\"meta\\\",\\\"meta_align\\\":\\\"bottom\\\",\\\"icon_ratio\\\":4,\\\"image_align\\\":\\\"between\\\",\\\"image_grid_width\\\":\\\"1-2\\\",\\\"image_breakpoint\\\":\\\"m\\\",\\\"link_text\\\":\\\"Read more\\\",\\\"link_style\\\":\\\"panel\\\",\\\"margin\\\":\\\"default\\\",\\\"item_animation\\\":\\\"fade\\\",\\\"gutter\\\":\\\"\\\",\\\"grid_small\\\":\\\"\\\",\\\"grid_large\\\":\\\"6\\\",\\\"grid_xlarge\\\":\\\"6\\\",\\\"filter_margin\\\":\\\"\\\",\\\"filter_gutter\\\":\\\"\\\",\\\"title_display\\\":\\\"\\\",\\\"content_display\\\":\\\"\\\",\\\"panel_style\\\":\\\"\\\",\\\"panel_size\\\":\\\"\\\",\\\"item_maxwidth\\\":\\\"\\\",\\\"title_style\\\":\\\"\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"meta_color\\\":\\\"\\\",\\\"meta_margin\\\":\\\"\\\",\\\"content_style\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"icon_color\\\":\\\"\\\",\\\"image_gutter\\\":\\\"\\\",\\\"link_size\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"link_target\\\":true,\\\"grid_masonry\\\":false,\\\"grid_parallax\\\":\\\"0\\\",\\\"image_height\\\":\\\"65\\\",\\\"divider\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"Westjet Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-Westjet.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.westjet.com\\\\\\/en-ca\\\\\\/index\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"Banff Centre Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-Banff-Centre.png\\\",\\\"image_alt\\\":\\\"\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.banffcentre.ca\\\\\\/\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"THNK Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-THNK-Leadership.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.thnk.org\\\\\\/\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"Lululemon Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-Lululemon.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/shop.lululemon.com\\\\\\/\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"MEC Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-MEC.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.mec.ca\\\\\\/en\\\\\\/\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"Go Pro Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-GoPro.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/gopro.com\\\\\\/\\\"}}]}]}]}]}],\\\"props\\\":[],\\\"version\\\":\\\"1.18.10\\\"} -->\",\"state\":\"1\",\"catid\":\"2\",\"created\":\"2019-02-05 00:11:17\",\"created_by\":\"301\",\"created_by_alias\":\"\",\"modified\":\"2019-02-28 19:53:11\",\"modified_by\":\"301\",\"checked_out\":\"0\",\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2019-02-05 00:11:17\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":211,\"ordering\":\"6\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"2725\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('675', '1', '1', '', '2019-02-28 20:05:29', '301', '53331', 'e1309cbaf0c532644cae71ecdd9d7c081847888f', '{\"id\":\"1\",\"asset_id\":\"63\",\"title\":\"home\",\"alias\":\"home\",\"introtext\":\"<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<a href=\\\"\\/\\\"><img src=\\\"images\\/EB-Images\\/Logos\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\" alt=\\\"\\\"><\\/a>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_HomeGraphic-SharedIdeasCollaboration-mobile.png\\\" alt=\\\"\\\">\\n<h6>&nbsp;<br \\/>&nbsp;<\\/h6>\\n<h3>Uncover possibilities<br \\/> that seem just beyond<br \\/> reach... one good conversation at a time.<\\/h3>\\n<h3><p><span style=\\\"font-size: 42px; line-height: 1.2em;\\\">Uncover possibilities<br \\/> that seem just beyond<br \\/> reach... one good conversation at a time.<\\/span><\\/p><\\/h3>\\n<h2><span style=\\\"font-size: 36px; line-height: 1.1em;\\\">Uncover possibilities that seem just beyond reach... one good conversation at a time.<\\/span><\\/h2>\\n<div><p>Create connection. Use laughter. Imagine change. Make a plan. This is how we shape strong teams and good leaders. I will help you learn how.<\\/p><\\/div>\\n<div><p><span style=\\\"font-size: 22pt; line-height: 22pt;\\\">Create connection. Use laughter. Imagine change. Make a plan. This is how we shape strong teams and good leaders. I will help you learn how.<\\/span><\\/p><\\/div>\\n<h2>EXPERIENCE IS EVERYTHING<\\/h2>\\n<div><div class=\\\"uk-visible@m\\\">I design & deliver tailored, transformative leadership and learning experiences for people, brands and businesses.<br><br>\\nWhether you\\u2019re part of a Fortune 500 company or a lone entrepreneur, I help uncover what matters most, and work closely with you to design the best solution.<\\/div>\\n\\n<div class=\\\"uk-hidden@m\\\"><span style=\\\"font-size: 22px; line-height: 1.25em;\\\">I design & deliver tailored, transformative leadership and learning experiences for people, brands and businesses.<br><br>\\nWhether you\\u2019re part of a Fortune 500 company or a lone entrepreneur, I help uncover what matters most, and work closely with you to design the best solution.<\\/span><\\/div><\\/div>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Spacer.png\\\" alt=\\\"\\\">\\n<h1>&nbsp;<br \\/>&nbsp;<\\/h1>\\n<h2>WHAT I BELIEVE<\\/h2>\\n<div><p><span style=\\\"color: #333333;\\\">The average person will spend 90,000 hours at work over a lifetime. I know, I had to sit down when I read it too. Work and life are not separate, which is why your life\\u2019s work needs to be a priority. We have an opportunity to go beyond daily survival skills and practice new ways to be confident, kind and successful humans in the world. That\\u2019s the work I do.<\\/span><\\/p><\\/div>\\n<h2>Here\\u2019s what it\\u2019s like to work with me:<\\/h2>\\n<div>\\u201cI know firsthand the positive impact Elaine has within organizations and I can always count on her to deliver. She is an expert in her field who I have seen bring out the best in the teams she works with. Elaine is a triple threat; designer, facilitator and leadership subject expert who brings a unique ability to create solutions for organizations.\\u201d\\n<\\/div>\\n<h4>JANEEN SPEER, VP TALENT<br>\\nSHOPIFY<\\/h4>\\n<div><p>\\u201cI have worked with hundreds of people who do what she does, both coaches and facilitators, and Elaine stands above them all. She is excellent at the many ways in which she supports clients and organizations. She is not like the rest, Elaine is in a league of her own.\\u201d<\\/p><\\/div>\\n<h4>SARAH DICKINSON, CO-FOUNDER AND MANAGING DIRECTOR<br>\\nTHNK SCHOOL OF CREATIVE LEADERSHIP<\\/h4>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_HomeQuotesGraphic.jpg\\\" alt=\\\"\\\">\\n<div><p>\\u201cThere I was, minding my own business taking an Executive Leadership Program and in front of the room, blowing my mind, was Elaine. She took us on a journey to shake us up and lead us through establishing a culture for innovative thinking while we laughed our way through design thinking exercises day after day. Mission fulfilled. At the end, I felt like the guy who loved the product so much I bought the company, but in this case I bought a little more of Elaine\'s time for my company.<\\/p>\\n<p>Currently with CAGR of 20% over the last four years, 2,000 employees and $1\\/2 Billion in managed assets, Innisfree is a dynamic, and growing organization. After Elaine\\u2019s first year with Innisfree\'s leadership team, I quickly came to the realization that I have done us a tremendous favor. Elaine has led Innisfree senior management through several iterations to begin the sea change of culture toward a more innovative environment.\\u201d\\n<\\/p><\\/div>\\n<h4>JULIAN MACQUEEN, CHAIRMAN & FOUNDER<br>\\nINNISFREE HOTELS<\\/h4>\\n<h2>Here\\u2019s what it\\u2019s like to work with me:<\\/h2>\\n<div>\\u201cI know firsthand the positive impact Elaine has within organizations and I can always count on her to deliver. She is an expert in her field who I have seen bring out the best in the teams she works with. Elaine is a triple threat; designer, facilitator and leadership subject expert who brings a unique ability to create solutions for organizations.\\u201d\\n<\\/div>\\n<h4>JANEEN SPEER, VP TALENT<br>\\nSHOPIFY<\\/h4>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_HomeTalkingHeadsGraphic2.png\\\" alt=\\\"\\\">\\n<h2>Tailor-made<br>\\nLeadership Experiences<\\/h2>\\n<div>You have the time, the budget and the desire to shape a memorable experience for your people. Your culture is distinct and you want a tailored solution to get to the next level. You\\u2019re seeking a skilled partner who gets you and your people. The good, the bad and the \\u201cyeah we really need to deal with that\\u201d parts of your organization.<\\/div>\\n<p>\\n    <a href=\\\"tailor-made-leadership\\\">Learn More<\\/a>\\n<\\/p>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Home-GroupCircleGraphic2.png\\\" alt=\\\"\\\">\\n<h2>Ready-made<br>\\nLearning Experiences<\\/h2>\\n<div>Your team or conference guests are in need of an inspired approach to evolve the way they think and lead. I promise I\\u2019ve never had anyone fall asleep, and I like a challenge. You\\u2019ll get experienced design and a waiting list of people who want to sign up. This catalogue provides solutions to enliven learning and connection with any group. Yes, even those groups.<\\/div>\\n<p>\\n    <a href=\\\"ready-made-learning\\\">Learn More<\\/a>\\n<\\/p>\\n<img src=\\\"images\\/EB-Images\\/Home\\/ElaineBroe_Home-HighFiveGraphic3.png\\\" alt=\\\"\\\">\\n<h2>One-to-one<br>\\nExecutive Coaching<\\/h2>\\n<div>You\\u2019ve got big ideas, tricky team dynamics or changes to lead. I\\u2019m skilled, caring, and will challenge that voice inside your head, you know the one. Set time aside to prioritize thoughtful reflection with an experienced advisor. I coach a select group of leaders and entrepreneurs who do the work to get results, and happen to have a good sense of humour, as well.<\\/div>\\n<p>\\n    <a href=\\\"one-to-one-coaching\\\">Learn More<\\/a>\\n<\\/p>\\n<h2>ELAINE IS LOVED BY THESE COMPANIES, AND MORE.<\\/h2>\\n<ul>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-Westjet.png\\\" alt=\\\"\\\">\\n\\n<h3>Westjet Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/www.westjet.com\\/en-ca\\/index\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-Banff-Centre.png\\\" alt=\\\"\\\">\\n\\n<h3>Banff Centre Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/www.banffcentre.ca\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-THNK-Leadership.png\\\" alt=\\\"\\\">\\n\\n<h3>THNK Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/www.thnk.org\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-Lululemon.png\\\" alt=\\\"\\\">\\n\\n<h3>Lululemon Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/shop.lululemon.com\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-MEC.png\\\" alt=\\\"\\\">\\n\\n<h3>MEC Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/www.mec.ca\\/en\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n        <li>\\n\\n        <img src=\\\"images\\/EB-Images\\/Logos\\/Clients\\/EB-clientlogo-GoPro.png\\\" alt=\\\"\\\">\\n\\n<h3>Go Pro Logo BW<\\/h3>\\n\\n\\n\\n<p><a href=\\\"https:\\/\\/gopro.com\\/\\\">Read more<\\/a><\\/p>\\n\\n    <\\/li>\\n    <\\/ul>\\n\",\"fulltext\":\"<!-- {\\\"name\\\":\\\"Home Page v2\\\",\\\"type\\\":\\\"layout\\\",\\\"children\\\":[{\\\"name\\\":\\\"Hero\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"primary\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"bottom-left\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"dark\\\",\\\"animation\\\":\\\"fade\\\",\\\"padding_remove_bottom\\\":true,\\\"padding_remove_top\\\":true,\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_width\\\":\\\"700\\\",\\\"image_height\\\":\\\"400\\\",\\\"overlap\\\":false,\\\"css\\\":\\\"@media only screen and (min-width: 1250px) {\\\\n.el-section {\\\\n    min-height: 638px;\\\\n}\\\\n\\\\n.uk-grid {\\\\n    min-height: 638px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1249px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 550px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1000px) {\\\\n\\\\n\\\\n.uk-grid {\\\\n    min-height: 350px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"s\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"expand\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"margin_remove_bottom\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"bottom-right\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeGraphic-SharedIdeasCollaboration_1x1Right.png\\\",\\\"image_size\\\":\\\"contain\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"m\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_height\\\":\\\"\\\",\\\"image_parallax_breakpoint\\\":\\\"\\\",\\\"image_parallax_bgx_start\\\":\\\"\\\",\\\"image_parallax_bgy_start\\\":\\\"70\\\",\\\"image_width\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"Image uk-visible@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"-55\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-20\\\",\\\"parallax_x_end\\\":\\\"-20\\\",\\\"parallax_y_end\\\":\\\"-55\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Image uk-hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"parallax\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/ElaineBroe_LOGO-FA-stack_ltgreyblack_low.png\\\",\\\"image_height\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"parallax_breakpoint\\\":\\\"\\\",\\\"parallax_y_start\\\":\\\"15\\\",\\\"class\\\":\\\"uk-hidden@m\\\",\\\"margin_remove_bottom\\\":true,\\\"link\\\":\\\"\\\\\\/\\\",\\\"parallax_x_start\\\":\\\"-5\\\",\\\"parallax_x_end\\\":\\\"-5\\\",\\\"parallax_y_end\\\":\\\"15\\\",\\\"image_width\\\":\\\"190\\\"}},{\\\"name\\\":\\\"Top Graphic hidden@m\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeGraphic-SharedIdeasCollaboration-mobile.png\\\",\\\"margin_remove_top\\\":false,\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden@m\\\",\\\"image_width\\\":\\\"250\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"light\\\",\\\"padding\\\":\\\"none\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  \\\\n  \\\\n  padding-left: 120px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n\\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n  padding-bottom: 20px;\\\\n}\\\\n}\\\\n\\\\n\\\\n.uk-tile-default {\\\\n    background: rgba(255, 255, 255, 0.0);\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"spacer @desktop\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h6\\\",\\\"title_style\\\":\\\"heading-hero\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"&nbsp;<br \\\\\\/>&nbsp;\\\",\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden\\\",\\\"margin_remove_top\\\":true}},{\\\"name\\\":\\\"Headline @L\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Uncover possibilities<br \\\\\\/> that seem just beyond<br \\\\\\/> reach... one good conversation at a time.\\\",\\\"class\\\":\\\"uk-light uk-visible@l hidden@m\\\"}},{\\\"name\\\":\\\"Headline @M\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h3\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"l\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 42px; line-height: 1.2em;\\\\\\\">Uncover possibilities<br \\\\\\/> that seem just beyond<br \\\\\\/> reach... one good conversation at a time.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@m uk-hidden@l\\\"}},{\\\"name\\\":\\\"Headline @S\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h3\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<span style=\\\\\\\"font-size: 36px; line-height: 1.1em;\\\\\\\">Uncover possibilities that seem just beyond reach... one good conversation at a time.<\\\\\\/span>\\\",\\\"class\\\":\\\"uk-hidden@m uk-light\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true}},{\\\"name\\\":\\\"Text @S hidden@s\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"small\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>Create connection. Use laughter. Imagine change. Make a plan. This is how we shape strong teams and good leaders. I will help you learn how.<\\\\\\/p>\\\",\\\"class\\\":\\\"uk-hidden@l uk-light uk-visible@m\\\",\\\"margin_remove_bottom\\\":false}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"xlarge\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"font-size: 22pt; line-height: 22pt;\\\\\\\">Create connection. Use laughter. Imagine change. Make a plan. This is how we shape strong teams and good leaders. I will help you learn how.<\\\\\\/span><\\\\\\/p>\\\",\\\"class\\\":\\\"uk-light uk-visible@l\\\"}}]}]}]},{\\\"name\\\":\\\"Intro\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"padding_remove_top\\\":false,\\\"padding_remove_bottom\\\":false,\\\"css\\\":\\\"\\\",\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"right\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"margin_remove_top\\\":true,\\\"margin_remove_bottom\\\":true,\\\"divider\\\":false,\\\"match\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"EXPERIENCE IS EVERYTHING\\\",\\\"css\\\":\\\"\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"large\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<div class=\\\\\\\"uk-visible@m\\\\\\\">I design & deliver tailored, transformative leadership and learning experiences for people, brands and businesses.<br><br>\\\\nWhether you\\\\u2019re part of a Fortune 500 company or a lone entrepreneur, I help uncover what matters most, and work closely with you to design the best solution.<\\\\\\/div>\\\\n\\\\n<div class=\\\\\\\"uk-hidden@m\\\\\\\"><span style=\\\\\\\"font-size: 22px; line-height: 1.25em;\\\\\\\">I design & deliver tailored, transformative leadership and learning experiences for people, brands and businesses.<br><br>\\\\nWhether you\\\\u2019re part of a Fortune 500 company or a lone entrepreneur, I help uncover what matters most, and work closely with you to design the best solution.<\\\\\\/span><\\\\\\/div>\\\",\\\"css\\\":\\\"\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-left\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeClassRoomCollaboration3.jpg\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Spacer.png\\\"}},{\\\"name\\\":\\\"spacer @mobile\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h1\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"&nbsp;<br \\\\\\/>&nbsp;\\\",\\\"margin_remove_bottom\\\":true,\\\"class\\\":\\\"uk-hidden@s\\\",\\\"margin_remove_top\\\":true}}]}]}]},{\\\"name\\\":\\\"What I believe\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"css\\\":\\\".el-section {\\\\n    background-color: #F8925E;\\\\n    \\\\n}\\\\n\\\\n@media only screen and (min-width: 1024px) {\\\\n    .uk-panel {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 40px; \\\\n  padding-left: 90px;\\\\n  padding-right: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .uk-panel {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n  padding-right: 30px;\\\\n}\\\\n}\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"WHAT I BELIEVE\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"large\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p><span style=\\\\\\\"color: #333333;\\\\\\\">The average person will spend 90,000 hours at work over a lifetime. I know, I had to sit down when I read it too. Work and life are not separate, which is why your life\\\\u2019s work needs to be a priority. We have an opportunity to go beyond daily survival skills and practice new ways to be confident, kind and successful humans in the world. That\\\\u2019s the work I do.<\\\\\\/span><\\\\\\/p>\\\"}}]}]}]},{\\\"name\\\":\\\"to work with me @desktop\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"muted\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"css\\\":\\\"\\\",\\\"class\\\":\\\"uk-visible@m\\\",\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"margin_remove_bottom\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  padding-top: 50px;\\\\n   \\\\n  padding-left: 115px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  padding-top: 30px;\\\\n   \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"heading-primary\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Here\\\\u2019s what it\\\\u2019s like to work with me:\\\"}}]}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"divider\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  \\\\n  padding-bottom: 60px; \\\\n  padding-left: 115px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  \\\\n  padding-bottom: 30px; \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"\\\\u201cI know firsthand the positive impact Elaine has within organizations and I can always count on her to deliver. She is an expert in her field who I have seen bring out the best in the teams she works with. Elaine is a triple threat; designer, facilitator and leadership subject expert who brings a unique ability to create solutions for organizations.\\\\u201d\\\\n\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h4\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"JANEEN SPEER, VP TALENT<br>\\\\nSHOPIFY\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"divider\\\",\\\"props\\\":{\\\"divider_element\\\":\\\"div\\\",\\\"divider_style\\\":\\\"small\\\",\\\"divider_align\\\":\\\"\\\",\\\"divider_align_breakpoint\\\":\\\"\\\",\\\"divider_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>\\\\u201cI have worked with hundreds of people who do what she does, both coaches and facilitators, and Elaine stands above them all. She is excellent at the many ways in which she supports clients and organizations. She is not like the rest, Elaine is in a league of her own.\\\\u201d<\\\\\\/p>\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h4\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"SARAH DICKINSON, CO-FOUNDER AND MANAGING DIRECTOR<br>\\\\nTHNK SCHOOL OF CREATIVE LEADERSHIP\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"divider\\\",\\\"props\\\":{\\\"divider_element\\\":\\\"div\\\",\\\"divider_style\\\":\\\"small\\\",\\\"divider_align\\\":\\\"\\\",\\\"divider_align_breakpoint\\\":\\\"\\\",\\\"divider_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 45px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\\n\\\\n\\\\\\/* Experimental *\\\\\\/\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"right\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeQuotesGraphic.jpg\\\",\\\"image_height\\\":\\\"50\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"<p>\\\\u201cThere I was, minding my own business taking an Executive Leadership Program and in front of the room, blowing my mind, was Elaine. She took us on a journey to shake us up and lead us through establishing a culture for innovative thinking while we laughed our way through design thinking exercises day after day. Mission fulfilled. At the end, I felt like the guy who loved the product so much I bought the company, but in this case I bought a little more of Elaine\'s time for my company.<\\\\\\/p>\\\\n<p>Currently with CAGR of 20% over the last four years, 2,000 employees and $1\\\\\\/2 Billion in managed assets, Innisfree is a dynamic, and growing organization. After Elaine\\\\u2019s first year with Innisfree\'s leadership team, I quickly came to the realization that I have done us a tremendous favor. Elaine has led Innisfree senior management through several iterations to begin the sea change of culture toward a more innovative environment.\\\\u201d\\\\n<\\\\\\/p>\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h4\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"JULIAN MACQUEEN, CHAIRMAN & FOUNDER<br>\\\\nINNISFREE HOTELS\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"divider\\\",\\\"props\\\":{\\\"divider_element\\\":\\\"div\\\",\\\"divider_style\\\":\\\"small\\\",\\\"divider_align\\\":\\\"\\\",\\\"divider_align_breakpoint\\\":\\\"\\\",\\\"divider_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"}}]}]}]},{\\\"name\\\":\\\"to work with me @mobile\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"muted\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"css\\\":\\\"\\\",\\\"class\\\":\\\"uk-hidden@m\\\",\\\"image_effect\\\":\\\"\\\",\\\"padding_remove_top\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"divider\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 115px;\\\\n  padding-right: 50px;\\\\n        \\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    .el-section {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 50px;\\\\n  padding-right: 15px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h1\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Here\\\\u2019s what it\\\\u2019s like to work with me:\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"\\\\u201cI know firsthand the positive impact Elaine has within organizations and I can always count on her to deliver. She is an expert in her field who I have seen bring out the best in the teams she works with. Elaine is a triple threat; designer, facilitator and leadership subject expert who brings a unique ability to create solutions for organizations.\\\\u201d\\\\n\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h4\\\",\\\"title_style\\\":\\\"h6\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"JANEEN SPEER, VP TALENT<br>\\\\nSHOPIFY\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"divider\\\",\\\"props\\\":{\\\"divider_element\\\":\\\"div\\\",\\\"divider_style\\\":\\\"small\\\",\\\"divider_align\\\":\\\"\\\",\\\"divider_align_breakpoint\\\":\\\"\\\",\\\"divider_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"}}]}]}]},{\\\"name\\\":\\\"Services - Tailor Made\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"animation_delay\\\":true,\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"divider\\\":false,\\\"margin_remove_bottom\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\".el-section {\\\\n    background-color: #9CC788;\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"slide-left-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeTalkingHeadsGraphic2.png\\\",\\\"image_height\\\":\\\"505\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"xsmall\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"heading-primary\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Tailor-made<br>\\\\nLeadership Experiences\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"You have the time, the budget and the desire to shape a memorable experience for your people. Your culture is distinct and you want a tailored solution to get to the next level. You\\\\u2019re seeking a skilled partner who gets you and your people. The good, the bad and the \\\\u201cyeah we really need to deal with that\\\\u201d parts of your organization.\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button\\\",\\\"props\\\":{\\\"gutter\\\":\\\"small\\\",\\\"margin\\\":\\\"default\\\",\\\"button_size\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button_item\\\",\\\"props\\\":{\\\"button_style\\\":\\\"default\\\",\\\"icon_align\\\":\\\"left\\\",\\\"link_target\\\":\\\"\\\",\\\"content\\\":\\\"Learn More\\\",\\\"link\\\":\\\"tailor-made-leadership\\\"}}]}]}]}]},{\\\"name\\\":\\\"Services - Ready-Made\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"animation_delay\\\":true,\\\"css\\\":\\\"@media (min-width: 960px){\\\\n.uk-tile {\\\\n    padding-left: 70px;\\\\n    padding-right: 40px;\\\\n    padding-top: 65px;\\\\n    padding-bottom: 65px;\\\\n}\\\\n}\\\",\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"divider\\\":false,\\\"margin_remove_bottom\\\":true,\\\"order_last\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\".el-section {\\\\n    background-color: #F4EBC6;\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"slide-right-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Home-GroupCircleGraphic2.png\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"xsmall\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"heading-primary\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Ready-made<br>\\\\nLearning Experiences\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"Your team or conference guests are in need of an inspired approach to evolve the way they think and lead. I promise I\\\\u2019ve never had anyone fall asleep, and I like a challenge. You\\\\u2019ll get experienced design and a waiting list of people who want to sign up. This catalogue provides solutions to enliven learning and connection with any group. Yes, even those groups.\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button\\\",\\\"props\\\":{\\\"gutter\\\":\\\"small\\\",\\\"margin\\\":\\\"default\\\",\\\"button_size\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button_item\\\",\\\"props\\\":{\\\"button_style\\\":\\\"default\\\",\\\"icon_align\\\":\\\"left\\\",\\\"link_target\\\":\\\"\\\",\\\"content\\\":\\\"Learn More\\\",\\\"link\\\":\\\"ready-made-learning\\\"}}]}]}]}]},{\\\"name\\\":\\\"Services - One-to-one\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"fade\\\",\\\"animation_delay\\\":true,\\\"image_effect\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\",\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"divider\\\":false,\\\"margin_remove_bottom\\\":true},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"secondary\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"none\\\",\\\"image\\\":\\\"\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"image\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"link_target\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"slide-left-medium\\\",\\\"visibility\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_Home-HighFiveGraphic3.png\\\"}}]},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"style\\\":\\\"default\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"xsmall\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"heading-primary\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"remove-vertical\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"One-to-one<br>\\\\nExecutive Coaching\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"text\\\",\\\"props\\\":{\\\"margin\\\":\\\"default\\\",\\\"column_breakpoint\\\":\\\"m\\\",\\\"text_style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"text_size\\\":\\\"\\\",\\\"column\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"You\\\\u2019ve got big ideas, tricky team dynamics or changes to lead. I\\\\u2019m skilled, caring, and will challenge that voice inside your head, you know the one. Set time aside to prioritize thoughtful reflection with an experienced advisor. I coach a select group of leaders and entrepreneurs who do the work to get results, and happen to have a good sense of humour, as well.\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button\\\",\\\"props\\\":{\\\"gutter\\\":\\\"small\\\",\\\"margin\\\":\\\"default\\\",\\\"button_size\\\":\\\"\\\",\\\"text_align\\\":\\\"\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"css\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"button_item\\\",\\\"props\\\":{\\\"button_style\\\":\\\"default\\\",\\\"icon_align\\\":\\\"left\\\",\\\"link_target\\\":\\\"\\\",\\\"content\\\":\\\"Learn More\\\",\\\"link\\\":\\\"one-to-one-coaching\\\"}}]}]}]}]},{\\\"name\\\":\\\"Image Parallax\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"default\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"percent\\\",\\\"padding\\\":\\\"\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Home\\\\\\/ElaineBroe_HomeElaineTeachesGroupBW.jpg\\\",\\\"image_size\\\":\\\"cover\\\",\\\"image_effect\\\":\\\"fixed\\\",\\\"image_visibility\\\":\\\"\\\",\\\"media_blend_mode\\\":\\\"\\\",\\\"image_parallax_breakpoint\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\"}}]}]},{\\\"name\\\":\\\"Clients - Partners\\\",\\\"type\\\":\\\"section\\\",\\\"props\\\":{\\\"style\\\":\\\"default\\\",\\\"width\\\":\\\"\\\",\\\"vertical_align\\\":\\\"middle\\\",\\\"title_position\\\":\\\"top-left\\\",\\\"title_rotation\\\":\\\"left\\\",\\\"title_breakpoint\\\":\\\"xl\\\",\\\"image_position\\\":\\\"center-center\\\",\\\"text_color\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"header_transparent\\\":\\\"\\\",\\\"animation\\\":\\\"slide-top-small\\\",\\\"animation_delay\\\":true,\\\"image_effect\\\":\\\"\\\",\\\"css\\\":\\\"@media only screen and (min-width: 1024px) {\\\\n    .el-section {\\\\n  padding-top: 60px;\\\\n  padding-bottom: 60px; \\\\n  padding-left: 90px;\\\\n  padding-right: 90px;\\\\n}\\\\n}\\\\n\\\\n@media only screen and (max-width: 1023px) {\\\\n    el-section {\\\\n  padding-top: 30px;\\\\n  padding-bottom: 30px; \\\\n  padding-left: 30px;\\\\n  padding-right: 30px;\\\\n}\\\\n}\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"row\\\",\\\"props\\\":{\\\"layout\\\":\\\"1-1\\\",\\\"breakpoint\\\":\\\"m\\\",\\\"fixed_width\\\":\\\"large\\\",\\\"gutter\\\":\\\"\\\",\\\"width\\\":\\\"\\\",\\\"width_expand\\\":\\\"\\\",\\\"height\\\":\\\"\\\",\\\"margin\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"column\\\",\\\"props\\\":{\\\"widths\\\":[\\\"1-1\\\"],\\\"image_position\\\":\\\"center-center\\\",\\\"media_overlay_gradient\\\":\\\"\\\",\\\"vertical_align\\\":\\\"\\\",\\\"style\\\":\\\"\\\",\\\"text_color\\\":\\\"\\\",\\\"padding\\\":\\\"\\\"},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"headline\\\",\\\"props\\\":{\\\"title_element\\\":\\\"h2\\\",\\\"title_style\\\":\\\"h4\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"margin\\\":\\\"large\\\",\\\"animation\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"content\\\":\\\"ELAINE IS LOVED BY THESE COMPANIES, AND MORE.\\\",\\\"margin_remove_top\\\":true}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid\\\",\\\"props\\\":{\\\"show_title\\\":false,\\\"show_meta\\\":false,\\\"show_content\\\":false,\\\"show_image\\\":true,\\\"show_link\\\":true,\\\"grid_default\\\":\\\"2\\\",\\\"grid_medium\\\":\\\"3\\\",\\\"filter_style\\\":\\\"tab\\\",\\\"filter_all\\\":true,\\\"filter_position\\\":\\\"top\\\",\\\"filter_align\\\":\\\"left\\\",\\\"filter_grid_width\\\":\\\"auto\\\",\\\"filter_breakpoint\\\":\\\"m\\\",\\\"title_element\\\":\\\"h3\\\",\\\"meta_style\\\":\\\"meta\\\",\\\"meta_align\\\":\\\"bottom\\\",\\\"icon_ratio\\\":4,\\\"image_align\\\":\\\"between\\\",\\\"image_grid_width\\\":\\\"1-2\\\",\\\"image_breakpoint\\\":\\\"m\\\",\\\"link_text\\\":\\\"Read more\\\",\\\"link_style\\\":\\\"panel\\\",\\\"margin\\\":\\\"default\\\",\\\"item_animation\\\":\\\"fade\\\",\\\"gutter\\\":\\\"\\\",\\\"grid_small\\\":\\\"\\\",\\\"grid_large\\\":\\\"6\\\",\\\"grid_xlarge\\\":\\\"6\\\",\\\"filter_margin\\\":\\\"\\\",\\\"filter_gutter\\\":\\\"\\\",\\\"title_display\\\":\\\"\\\",\\\"content_display\\\":\\\"\\\",\\\"panel_style\\\":\\\"\\\",\\\"panel_size\\\":\\\"\\\",\\\"item_maxwidth\\\":\\\"\\\",\\\"title_style\\\":\\\"\\\",\\\"title_decoration\\\":\\\"\\\",\\\"title_color\\\":\\\"\\\",\\\"meta_color\\\":\\\"\\\",\\\"meta_margin\\\":\\\"\\\",\\\"content_style\\\":\\\"\\\",\\\"image_border\\\":\\\"\\\",\\\"image_box_shadow\\\":\\\"\\\",\\\"image_hover_box_shadow\\\":\\\"\\\",\\\"image_box_decoration\\\":\\\"\\\",\\\"icon_color\\\":\\\"\\\",\\\"image_gutter\\\":\\\"\\\",\\\"link_size\\\":\\\"\\\",\\\"text_align\\\":\\\"center\\\",\\\"text_align_breakpoint\\\":\\\"\\\",\\\"text_align_fallback\\\":\\\"\\\",\\\"maxwidth\\\":\\\"\\\",\\\"maxwidth_align\\\":\\\"\\\",\\\"maxwidth_breakpoint\\\":\\\"\\\",\\\"visibility\\\":\\\"\\\",\\\"link_target\\\":true,\\\"grid_masonry\\\":false,\\\"grid_parallax\\\":\\\"0\\\",\\\"image_height\\\":\\\"65\\\",\\\"divider\\\":false},\\\"children\\\":[{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"Westjet Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-Westjet.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.westjet.com\\\\\\/en-ca\\\\\\/index\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"Banff Centre Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-Banff-Centre.png\\\",\\\"image_alt\\\":\\\"\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.banffcentre.ca\\\\\\/\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"THNK Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-THNK-Leadership.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.thnk.org\\\\\\/\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"Lululemon Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-Lululemon.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/shop.lululemon.com\\\\\\/\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"MEC Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-MEC.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/www.mec.ca\\\\\\/en\\\\\\/\\\"}},{\\\"name\\\":\\\"\\\",\\\"type\\\":\\\"grid_item\\\",\\\"props\\\":{\\\"title\\\":\\\"Go Pro Logo BW\\\",\\\"image\\\":\\\"images\\\\\\/EB-Images\\\\\\/Logos\\\\\\/Clients\\\\\\/EB-clientlogo-GoPro.png\\\",\\\"link\\\":\\\"https:\\\\\\/\\\\\\/gopro.com\\\\\\/\\\"}}]}]}]}]}],\\\"props\\\":[],\\\"version\\\":\\\"1.18.10\\\"} -->\",\"state\":\"1\",\"catid\":\"2\",\"created\":\"2019-02-05 00:11:17\",\"created_by\":\"301\",\"created_by_alias\":\"\",\"modified\":\"2019-02-28 20:05:29\",\"modified_by\":\"301\",\"checked_out\":\"0\",\"checked_out_time\":\"0000-00-00 00:00:00\",\"publish_up\":\"2019-02-05 00:11:17\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\"}\",\"version\":212,\"ordering\":\"6\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"2733\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0');/**ABDB**/
