<?php

namespace YOOtheme\Builder\Joomla\Source\Type;

use Joomla\CMS\Factory;
use YOOtheme\Builder\Source;

class SiteQueryType
{
    /**
     * @param Source $source
     *
     * @return array
     */
    public function __invoke(Source $source)
    {
        $fields = [

            'site' => [
                'type' => 'Site',
                'metadata' => [
                    'label' => 'Site',
                ],
            ],

        ];

        $resolvers = $source->mapResolvers($this);

        return compact('fields', 'resolvers');
    }

    public function site()
    {
        $config = Factory::getConfig();
        $document = Factory::getDocument();

        return [
            'title' => $config->get('sitename'),
            'page_title' => $document->getTitle(),
        ];
    }
}
